function [e, p] = CheckErrors(y_out, y_desired)
%
% use training data to determine accuracy and confusion matrices
% y_out 		- output from the network
% y_desired 	- desired class labels

[TEST_MAX, NC] = size(y_out);
% N# data points x N classes

Conf=zeros(NC,NC);  % confusion matrix
Confp=Conf;

for i=1:TEST_MAX

[yy id]=max(y_desired(i,:));  % id - desired class
[yy io]=max(y_out(i,:));         % io - obtained class
Conf(id,io)=Conf(id,io)+1; 
Confp(id,:)=Confp(id,:)+y_out(i,:); 

end

% calculate conditional confusion; Sensitivity and Specificity etc
for i=1:NC
s(i)=max(0.001, sum(Conf(i,:)));
Confcond(i,:)=Conf(i,:)/s(i);
end

format short; format compact;  
Conf
Confcond
Confp

p = trace(Conf)/TEST_MAX;  % accuracy
e=TEST_MAX-trace(Conf);    % error
disp([' N. err= ' num2str(e) ',  Acc = ' num2str(p)]);
