
clear;
clf;
clc

nin = 4;				% Number of inputs.
nhidden = 5;		% Number of hidden units.
nout = 3;			% Number of outputs.
alpha = 0.25;		% Coefficient of weight-decay prior. 
Nnoisepoints=0;  	% add some noise
VarNoise=0.01;	% with this variance

DS = DataSetLoad('..\data\iris.dat',nin);

DS.Inputs = Normdata(DS.Inputs);

net = mlp(nin, nhidden, nout, 'logistic', alpha);

options = zeros(1,18);
options(1) = 0;			% This provides display of error values.
options(14) = 200;		% Number of training cycles. 

[xt, yt ] = DataSetSplit(DS, 66);

% Train using scaled conjugate gradients.
[net, options] = netopt(net, options, xt, yt, 'scg');
net.options = options;

DS.Outputs = mlpfwd(net, DS.Inputs);

[e, p] = CheckErrors(DS.Outputs, DS.Desired);

PlotNoise(DS, net, Nnoisepoints, VarNoise)

%DataSetPlot(DS,10);
%DataSetPlotNoise(DS,net,3,5);
