% Lorenz attractor 3D data, mapped to two points by MLP ... 
clear
clc
clf

nin = 3;			% Number of inputs.
nhidden = 2;			% Number of hidden units.
nout = 2;			% Number of outputs.
alpha = 0.5;			% Coefficient of weight-decay prior.

DS = DataSetLoad('..\data\lorentz.dat', nin);

%DS.Inputs = Normdata(DS.Inputs);

net = mlp(nin, nhidden, nout, 'logistic', alpha);
options = zeros(1,18);
options(1) = 0;			% This provides display of error values.
options(14) = 2;		% Number of training cycles. 

[xt, yt, DS_test.Inputs, DS_test.Desired] = DataSetSplit(DS, 66);

[net, options] = netopt(net, options, xt, yt, 'scg');
net.options = options;

DS_test.Outputs = mlpfwd(net, DS_test.Inputs);

[e, p] = CheckErrors(DS_test.Outputs, DS_test.Desired);
DataSetPlotNoise(DS_test,net,10,10);

