%  Use NETLAB to create network and do calculations
%  this version prints only data with noise added

clear
clc;clf

nin = 13;			% Number of inputs.
nout = 3;			% Number of outputs.

nhidden = 3;			% Number of hidden units.
alpha     = 0.05;		% Coefficient of weight-decay prior. 

Nnoisepoints=1;  	% add some noise
VarNoise=0.05;		% with this variance

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 

DS = DataSetLoad('..\data\wine.dat',nin);
disp('Loaded: Wine data')  
disp([' nin= ' num2str(nin) ' nout = ' num2str(nout)])
disp([' Input size= ' num2str(size(DS.Inputs)) ]) 

DS.Inputs = Normdata(DS.Inputs);
%			
net = mlp(nin, nhidden, nout, 'logistic', alpha);
options = zeros(1,18);
options(1) = 0;				% This provides display of error values.
options(2) = 0.001;			% Termination criterion.
options(3) = 0.001;			% Termination criterion for error functions.
options(14) = 10	;		% Number of training cycles. 
options(17) = 0.1;			% Momentum. 

%	Split data to train and test - but test on all? 
[xt, yt] = DataSetSplit(DS, 100);
disp([' Train set size= ' num2str(size(xt)) ]) 

%  Optimize network, on train data [xt, yt], with SCG method
disp([' Train epochs= ' num2str(options(14)) ',  Regularization a=' num2str(alpha)]) 

[net, options] = netopt(net, options, xt, yt, 'scg');
net.options = options;

DS.Outputs = mlpfwd(net, DS.Inputs);

[e, p] = CheckErrors(DS.Outputs, DS.Desired);

% Plot data and noise, define marker sizes and colors
PlotNoise(DS, net, Nnoisepoints, VarNoise)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

