clear
clc;clf

iInput = 13;  	% Number of inputs.
iHidden = 6;	% Number of hidden units.
iOut = 3;		% Number of outputs.
Nnoisepoints=0;  	% add some noise
VarNoise=0.03;		% with this variance

DS = DataSetLoad('..\data\wine.dat',iInput);
disp('Loaded: Wine data')  
disp([' iInput= ' num2str(iInput) ' iOut = ' num2str(iOut)])
disp([' Input size= ' num2str(size(DS.Inputs)) ',  iHidden= ' num2str(iHidden) ]) 

DS.Inputs = Normdata(DS.Inputs);

net = rbf(iInput, iHidden, iOut, 'gaussian');
options = foptions;
options(1) = 0;			% Display EM training
options(14) = 200;	   	% number of iterations of EM (default 100)
net.options = options;

%CrossValidation(DataSet,net, 10)
%	Split data to train and test - but test on all? 

[xt, yt]= DataSetSplit(DS, 100);
disp([' Train set size= ' num2str(size(xt)) ]) 

%  Optimize network, on train data [xt, yt], with EM method
disp([' Train epochs= ' num2str(options(14)) ]) 
net = rbftrain(net, net.options, xt, yt);

[DS.Outputs,g,n2] = rbffwd(net,DS.Inputs);
[e, p] = CheckErrors(DS.Outputs, DS.Desired);
disp([' N. err= ' num2str(e) ',  Acc = ' num2str(p)])


% DataSetPlot(DS, 10);
% DataSetPlotNoise(DS, net, 1, 30);

PlotNoise(DS, net, Nnoisepoints, VarNoise)
