using System;
using System.Collections.Generic;
using System.Text;
using Intemi;

namespace ToyMachines
{

    public class TMConfig : IConfiguration
    {
        public void Configure(ConfigBuilder confBuilder)
        {
	        confBuilder.DeclareInput("Dataset",
	            new Type[] { typeof(IDataTable), typeof(ITargets) });
            confBuilder.DeclareOutput("Classifier", "ClassSubmachine",
                new Type[] { typeof(IClassifier) });

            ConfigBase c = confBuilder.project.GetConfiguration("kNN");
            ConfigBase c2 = confBuilder.project.GetConfiguration("Naive Bayesian Classifier");
            confBuilder.Subconfigurations.Add(0, c);
            confBuilder.Subconfigurations.Add(1, c2);
        }
        public object Clone() { return new TMConfig(); }
    }

    [Machine("TM", typeof(TMConfig))]
    public class TM : IMachine
    {
        IMachineBase machineBase;
        IClassifier classSubmachine = null;
        public void SetMachineBase(IMachineBase mb) { machineBase = mb; }

        public IClassifier ClassSubmachine
        {
            get { return classSubmachine; }
        }

        public void Run(ref bool shouldTerminate)
        {
            machineBase.Submachines.Count = 100;

            ConfigBase c = machineBase.ConfBase.Subconfigurations[0];
            c.Inputs.BindParentInput("Dataset", "Dataset"); 
            for (int i = 0; i < 50; i++)
            {
                ConfigBase cx = (ConfigBase)c.Clone();
                ((kNNConfig)cx.Configuration).K = i+1;
                machineBase.Submachines.Create(i, cx);
            }

            ConfigBase c2 = machineBase.ConfBase.Subconfigurations[1];
            c2.Inputs.BindParentInput("Dataset", "Dataset"); 
            for (int i = 0; i < 50; i++)
                machineBase.Submachines.Create(i+50, (ConfigBase)c2.Clone());

            machineBase.Submachines.WaitAll();

            Random r = new Random();
            classSubmachine = (IClassifier)
                machineBase.Submachines[r.Next(99)].GetOutput("Classifier");
        }
    }
}
