using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using Intemi;
using Intemi.Query;
using Intemi.Classifiers.DT;
//using Intemi.MissingData;

namespace TutorialPrg
{
    public class TutorialExpl
    {
        static protected string dataPath = 
            Environment.GetEnvironmentVariable("CI_DATA", EnvironmentVariableTarget.User);

        public static void MDMissingGen1Test(Project project)
        {
            Console.WriteLine(dataPath);

            // Wczytanie danych uczcych
            ConfigBase dc = project.GetConfiguration("GM data loader");
            DataLoaderConfig dcfg = (DataLoaderConfig)dc.Configuration;
            dcfg.InputFileName = "C:\\Documents and Settings\\nonone\\Pulpit\\MAGISTERKA\\breast-cancer-test.dat";
            //dcfg.InputFileName = "C:\\Documents and Settings\\nonone\\Pulpit\\MAGISTERKA\\iris-test.dat";
            Capsule dcaps = project.Create(dc);

            // Uczenie na podstawie danych uczcych 10% lossrate
            ConfigBase MDMissingGenConfig10 = project.GetConfiguration("MDMissingGen");
            MDMissingGenConfig MDMissingGenConfig10s = (MDMissingGenConfig)(MDMissingGenConfig10.Configuration);
            MDMissingGenConfig10s.LossRate = 10;
            MDMissingGenConfig10.Inputs.BindCapsule("Dataset", dcaps, "Dataset");
            Capsule missGenCapsule10 = project.Create(MDMissingGenConfig10);

            // Uczenie na podstawie danych uczcych 30% lossrate
            ConfigBase MDMissingGenConfig30 = project.GetConfiguration("MDMissingGen");
            MDMissingGenConfig MDMissingGenConfig30s = (MDMissingGenConfig)(MDMissingGenConfig30.Configuration);
            MDMissingGenConfig30s.LossRate = 30;
            MDMissingGenConfig30.Inputs.BindCapsule("Dataset", dcaps, "Dataset");
            Capsule missGenCapsule30 = project.Create(MDMissingGenConfig30);

            // Uczenie na podstawie danych uczcych 50% lossrate
            ConfigBase MDMissingGenConfig50 = project.GetConfiguration("MDMissingGen");
            MDMissingGenConfig MDMissingGenConfig50s = (MDMissingGenConfig)(MDMissingGenConfig50.Configuration);
            MDMissingGenConfig50s.LossRate = 50;
            MDMissingGenConfig50.Inputs.BindCapsule("Dataset", dcaps, "Dataset");
            Capsule missGenCapsule50 = project.Create(MDMissingGenConfig50);

            // Uczenie na podstawie danych uczcych 70% lossrate
            ConfigBase MDMissingGenConfig70 = project.GetConfiguration("MDMissingGen");
            MDMissingGenConfig MDMissingGenConfig70s = (MDMissingGenConfig)(MDMissingGenConfig70.Configuration);
            MDMissingGenConfig70s.LossRate = 70;
            MDMissingGenConfig70.Inputs.BindCapsule("Dataset", dcaps, "Dataset");
            Capsule missGenCapsule70 = project.Create(MDMissingGenConfig70);

            project.WaitAll();
            IDataTable labels10 = (IDataTable)missGenCapsule10.Machine.GetOutput("Dataset");
            (labels10 as DataTableWithTargets).SaveGMDFile("C:\\Documents and Settings\\nonone\\Pulpit\\MAGISTERKA\\breast-cancer-test10.dat");
            IDataTable labels30 = (IDataTable)missGenCapsule30.Machine.GetOutput("Dataset");
            (labels30 as DataTableWithTargets).SaveGMDFile("C:\\Documents and Settings\\nonone\\Pulpit\\MAGISTERKA\\breast-cancer-test30.dat");
            IDataTable labels50 = (IDataTable)missGenCapsule50.Machine.GetOutput("Dataset");
            (labels50 as DataTableWithTargets).SaveGMDFile("C:\\Documents and Settings\\nonone\\Pulpit\\MAGISTERKA\\breast-cancer-test50.dat");
            IDataTable labels70 = (IDataTable)missGenCapsule70.Machine.GetOutput("Dataset");
            (labels70 as DataTableWithTargets).SaveGMDFile("C:\\Documents and Settings\\nonone\\Pulpit\\MAGISTERKA\\breast-cancer-test70.dat");
        }

        public static void MDBasic1Test(Project project)
        {
            Console.WriteLine(dataPath);

            // Wczytanie danych uczcych
            ConfigBase dc = project.GetConfiguration("GM data loader");
            DataLoaderConfig dcfg = (DataLoaderConfig)dc.Configuration;
            dcfg.InputFileName = "C:\\Documents and Settings\\nonone\\Pulpit\\MAGISTERKA\\breast-cancer-test.dat";
            //dcfg.InputFileName = "C:\\Documents and Settings\\nonone\\Pulpit\\MAGISTERKA\\iris.dat";
            Capsule dcaps = project.Create(dc);

            // Uczenie na podstawie danych uczcych
            //ConfigBase MDkNNConfig = project.GetConfiguration("NaiveMethod");
            //ConfigBase MDkNNConfig = project.GetConfiguration("MDkNN");
            //ConfigBase MDkNNConfig = project.GetConfiguration("MDExpectationMaximization");
            ConfigBase MDkNNConfig = project.GetConfiguration("MDDataAugmentation");
            MDkNNConfig.Inputs.BindCapsule("Dataset", dcaps, "Dataset");
            Capsule naiveCapsule = project.Create(MDkNNConfig);

            // Klasyfikacja
            ConfigBase cc = project.GetConfiguration("1NN");
            //ConfigBase cc = project.GetConfiguration("Naive Bayesian Classifier");
            cc.Inputs.BindCapsule("Dataset", naiveCapsule, "Dataset");
            Capsule cccaps = project.Create(cc);

            // Wczytanie danych testowych
            ConfigBase dc_test = project.GetConfiguration("GM data loader");
            DataLoaderConfig dcfg_test = (DataLoaderConfig)dc_test.Configuration;
            dcfg_test.InputFileName = "C:\\Documents and Settings\\nonone\\Pulpit\\MAGISTERKA\\breast-cancer-test70.dat";
            //dcfg_test.InputFileName = "C:\\Documents and Settings\\nonone\\Pulpit\\MAGISTERKA\\iris70.dat";
            Capsule dcaps_test = project.Create(dc_test);

            ConfigBase etc = project.GetConfiguration("External transformation");
            etc.Inputs.BindCapsule("Dataset", dcaps_test, "Dataset");
            etc.Inputs.BindCapsule("Data transformer", naiveCapsule, "MissingDataFiller");
            Capsule etccaps = project.Create(etc);

            ConfigBase tc = project.GetConfiguration("Classification test");
            //tc.Inputs.BindCapsule("Dataset", naiveCapsule, "Dataset");
            tc.Inputs.BindCapsule("Dataset", etccaps, "Transformed data");
            tc.Inputs.BindCapsule("Classifier", cccaps, "Classifier");
            Capsule tcaps = project.Create(tc);

            project.WaitAll();
            IDataTable labels = (IDataTable)tcaps.Machine.GetOutput("Class labels");
            //IDataTable filledData = (IDataTable)etccaps.Machine.GetOutput("Transformed data");
            PlainDTSaver.Save(labels, "C:\\Documents and Settings\\nonone\\Pulpit\\MAGISTERKA\\ClassLabels.txt");
            //PlainDTSaver.Save(filledData, "C:\\Documents and Settings\\nonone\\Pulpit\\MAGISTERKA\\filledData.txt");
            Console.WriteLine("Accuracy: {0}", tcaps.Machine.ResultsRepository["Accuracy"]);
        }

        public static void MDBasicClass1Test(Project project)
        {
            Console.WriteLine(dataPath);
            ConfigBase dc = project.GetConfiguration("GM data loader");
            DataLoaderConfig dcfg = (DataLoaderConfig)dc.Configuration;
            //dcfg.InputFileName = dataPath + "iris.dat";
            dcfg.InputFileName = "C:\\Documents and Settings\\nonone\\Pulpit\\MAGISTERKA\\iris.dat";
            Console.WriteLine("Path: " + dcfg.InputFileName);
            Capsule dcaps = project.Create(dc);

            ConfigBase MDNaiveMethodClassConfig = project.GetConfiguration("NaiveMethodClass");
            MDNaiveMethodClassConfig.Inputs.BindCapsule("Dataset", dcaps, "Dataset");
            Capsule naiveCapsule = project.Create(MDNaiveMethodClassConfig);

            project.WaitAll();
        }

        public static void MDkNN1Test(Project project)
        {
            Console.WriteLine(dataPath);
            ConfigBase dc = project.GetConfiguration("GM data loader");
            DataLoaderConfig dcfg = (DataLoaderConfig)dc.Configuration;
            //dcfg.InputFileName = dataPath + "iris.dat";
            dcfg.InputFileName = "C:\\Documents and Settings\\nonone\\Pulpit\\MAGISTERKA\\iris.dat";
            Console.WriteLine("Path: " + dcfg.InputFileName);
            Capsule dcaps = project.Create(dc);

            ConfigBase MDkNNConfig = project.GetConfiguration("MDkNN");
            MDkNNConfig.Inputs.BindCapsule("Dataset", dcaps, "Dataset");
            Capsule naiveCapsule = project.Create(MDkNNConfig);

            project.WaitAll();
        }

        public static void MDEM1Test(Project project)
        {
            Console.WriteLine(dataPath);
            ConfigBase dc = project.GetConfiguration("GM data loader");
            DataLoaderConfig dcfg = (DataLoaderConfig)dc.Configuration;
            //dcfg.InputFileName = dataPath + "iris.dat";
            dcfg.InputFileName = "C:\\Documents and Settings\\nonone\\Pulpit\\MAGISTERKA\\iris.dat";
            Console.WriteLine("Path: " + dcfg.InputFileName);
            Capsule dcaps = project.Create(dc);

            ConfigBase MDExpectationMaximizationConfig = project.GetConfiguration("MDExpectationMaximization");
            MDExpectationMaximizationConfig.Inputs.BindCapsule("Dataset", dcaps, "Dataset");
            Capsule naiveCapsule = project.Create(MDExpectationMaximizationConfig);

            project.WaitAll();
        }

        public static void MDDA1Test(Project project)
        {
            Console.WriteLine(dataPath);
            ConfigBase dc = project.GetConfiguration("GM data loader");
            DataLoaderConfig dcfg = (DataLoaderConfig)dc.Configuration;
            //dcfg.InputFileName = dataPath + "iris.dat";
            dcfg.InputFileName = "C:\\Documents and Settings\\nonone\\Pulpit\\MAGISTERKA\\iris.dat";
            Console.WriteLine("Path: " + dcfg.InputFileName);
            Capsule dcaps = project.Create(dc);

            ConfigBase MDDAConfig = project.GetConfiguration("MDDataAugmentation");
            MDDAConfig.Inputs.BindCapsule("Dataset", dcaps, "Dataset");
            Capsule naiveCapsule = project.Create(MDDAConfig);

            project.WaitAll();
        }

        public static void DataPrint(Project project)
        {
            ConfigBase dc = project.GetConfiguration("GM data loader");
            DataLoaderConfig dcfg = (DataLoaderConfig)dc.Configuration;
            dcfg.InputFileName = dataPath + "iris.dat";
            Capsule dcaps = project.Create(dc);

            project.WaitAll();

            IDataSet d = dcaps.Machine.GetOutput("Dataset") as IDataSet;
            IDataTable dt = d as IDataTable;
            IVectorEnumerator ve = (IVectorEnumerator)dt.InstanceEnumerator();
            float[] values = ve.Vector;
            bool[] braki = ve.Missing;

            IOneFeatureData t = (d as ITargets).Targets;
            IVectorEnumerator tv = t.FeatureEnumerator();
            float[] lab = tv.Vector;
            tv.GoToInstance(0);
            IFeature f = t.FeatureInfo;
            for (int j = 0; j < dt.InstanceCount; j++)
            {
                ve.GoToInstance(j);
                for (int i = 0; i < dt.FeaturesCount; i++)
                    Console.Write("{0} ", values[i]);

                //Console.Write("{0}", lab[j]);
                Console.Write("{0}", f.Value((int)lab[j]));
                Console.WriteLine();
            }

            for (int i = 0; i < dt.FeaturesCount; i++)
                Console.WriteLine("Cecha: {0} jest {1}.", dt.FeaturesInfo[i].Name,
                    dt.FeaturesInfo[i].Ordered ? "porzdkowa" : "nieporzdkowa");

            Console.WriteLine("Liczba klas: {0}", t.FeatureInfo.NrValues);
            Console.Write("Klasy: ");
            for (int i = 0; i < t.FeatureInfo.NrValues; i++)
                Console.Write("{0} ", t.FeatureInfo.Value(i));
            Console.WriteLine();

            //dt.FeaturesInfo[0].Ordered;
            //dt.FeatureStatistics[0].counts[0];
            //dt.FeaturesInfo[0].NrValues;
        }
        public static void DataPrint2(Project project)
        {
            ConfigBase dc = project.GetConfiguration("GM data loader");
            DataLoaderConfig dcfg = (DataLoaderConfig)dc.Configuration;
            dcfg.InputFileName = dataPath + "iris.dat";
            Capsule dcaps = project.Create(dc);

            ConfigBase discConf = project.GetConfiguration("Equal Width Discretizer");
            EqWDiscretizerConfig discConf_c = (EqWDiscretizerConfig)(discConf.Configuration);
            discConf_c.K = 3;
            discConf.Inputs.BindCapsule("Dataset", dcaps, "Dataset");
            Capsule discCaps = project.Create(discConf);

            project.WaitAll();

            IDataSet d = discCaps.Machine.GetOutput("Dataset") as IDataSet;
            IDataTable dt = d as IDataTable;
            IVectorEnumerator ve = (IVectorEnumerator)dt.InstanceEnumerator();
            float[] values = ve.Vector;
            bool[] braki = ve.Missing;

            IOneFeatureData t = (d as ITargets).Targets;
            IVectorEnumerator tv = t.FeatureEnumerator();
            float[] lab = tv.Vector;
            tv.GoToInstance(0);
            IFeature f = t.FeatureInfo;
            for (int j = 0; j < dt.InstanceCount; j++)
            {
                ve.GoToInstance(j);
                for (int i = 0; i < dt.FeaturesCount; i++)
                    Console.Write("{0} ", values[i]);

                //Console.Write("{0}", lab[j]);
                Console.Write("{0}", f.Value((int)lab[j]));
                Console.WriteLine();
            }

            for (int i = 0; i < t.FeatureInfo.NrValues; i++)
                Console.WriteLine("Liczba wektorw klasy {0}: {1}",
                    t.FeatureInfo.Value(i), t.FeatureStatistics.counts[i]);

            for (int i = 0; i < dt.FeaturesCount; i++)
                Console.WriteLine("Cecha: {0} jest {1}.", dt.FeaturesInfo[i].Name,
                    dt.FeaturesInfo[i].Ordered ? "porzdkowa" : "nieporzdkowa");

            Console.WriteLine("Liczba klas: {0}", t.FeatureInfo.NrValues);
            Console.Write("Klasy: ");
            for (int i = 0; i < t.FeatureInfo.NrValues; i++)
                Console.Write("{0} ", t.FeatureInfo.Value(i));
            Console.WriteLine();

            //dt.FeaturesInfo[0].Ordered;
            //dt.FeatureStatistics[0].counts[0];
            //dt.FeaturesInfo[0].NrValues;
        }

        public static void MachineTest(Project project)
        {
            ConfigBase dc = project.GetConfiguration("GM data loader");
            DataLoaderConfig dcfg = (DataLoaderConfig)dc.Configuration;
            //dcfg.InputFileName = dataPath + "iris.dat";
            //dcfg.InputFileName = dataPath + "mushroom.dat";
            dcfg.InputFileName = dataPath + "thyroid-trs.dat";
            Capsule dcaps = project.Create(dc);

            ConfigBase cc = project.GetConfiguration("1NN");
            //ConfigBase cc = project.GetConfiguration("Naive Bayesian Classifier");
            cc.Inputs.BindCapsule("Dataset", dcaps, "Dataset");
            Capsule cccaps = project.Create(cc);

            ConfigBase tc = project.GetConfiguration("Classification test");
            //ClassTestConfig tcfg = (ClassTestConfig)tc.Configuration;
            tc.Inputs.BindCapsule("Dataset", dcaps, "Dataset");
            tc.Inputs.BindCapsule("Classifier", cccaps, "Classifier");
            Capsule tcaps = project.Create(tc);

            project.WaitAll();

            IDataTable labels = (IDataTable)tcaps.Machine.GetOutput("Class labels");
            IDataTable confMatrix = (IDataTable)tcaps.Machine.GetOutput("Confusion matrix");

            PlainDTSaver.Save(labels, "ClassLabels.txt");
            PlainDTSaver.Save(confMatrix, "ConfMatrix.txt");
        }
        public static void MachineTest2aMajority(Project project)
        {
            ConfigBase dc = project.GetConfiguration("GM data loader");
            DataLoaderConfig dcfg = (DataLoaderConfig)dc.Configuration;
            dcfg.InputFileName = dataPath + "iris.dat";
            Capsule dcaps = project.Create(dc);

            ConfigBase stdConfig = project.GetConfiguration("Standardization");
            stdConfig.Inputs.BindCapsule("Dataset", dcaps, "Dataset");
            Capsule stdCapsule = project.Create(stdConfig);

            ConfigBase cConf = project.GetConfiguration("1NN");
            cConf.Inputs.BindCapsule("Dataset", stdCapsule, "Dataset");
            Capsule nncaps = project.Create(cConf);

            ConfigBase tc = project.GetConfiguration("Classification test");
            //ClassTestConfig tcfg = (ClassTestConfig)tc.Configuration;
            tc.Inputs.BindCapsule("Dataset", stdCapsule, "Dataset");
            tc.Inputs.BindCapsule("Classifier", nncaps, "Classifier");
            Capsule tcaps = project.Create(tc);

            project.WaitAll();

            IDataTable labels = (IDataTable)tcaps.Machine.GetOutput("Class labels");
            IDataTable confMatrix = (IDataTable)tcaps.Machine.GetOutput("Confusion matrix");

            PlainDTSaver.Save(labels, "ClassLabels.txt");
            PlainDTSaver.Save(confMatrix, "ConfMatrix.txt");
        }
        public static void MachineTest3Box(Project project)
        {
            ConfigBase dc = project.GetConfiguration("GM data loader");
            DataLoaderConfig dcfg = (DataLoaderConfig)dc.Configuration;
            dcfg.InputFileName = dataPath + "iris.dat";
            Capsule dcaps = project.Create(dc);

            ConfigBase nnc = project.GetConfiguration("1NN");
            nnc.Inputs.BindParentInput("Dataset", "Dataset");

            SchemeConfig bc = new SchemeConfig();
            bc.DeclareInput("Dataset", new Type[] { typeof(IDataTable) });
            bc.DeclareOutput("Classifier", new Type[] { typeof(IClassifier) });
            bc.Subconfigurations.Add(0, nnc);
            bc.DeclareOutputBinding("Classifier", 0, "Classifier");
            ConfigBase boxConfBase = project.GetConfiguration(bc);
            boxConfBase.Inputs.BindCapsule("Dataset", dcaps, "Dataset");
            Capsule boxCaps = project.Create(boxConfBase);

            ConfigBase tc = project.GetConfiguration("Classification test");
            //ClassTestConfig tcfg = (ClassTestConfig)tc.Configuration;
            tc.Inputs.BindCapsule("Dataset", dcaps, "Dataset");
            tc.Inputs.BindCapsule("Classifier", boxCaps, "Classifier");
            Capsule tcaps = project.Create(tc);

            project.WaitAll();

            IDataTable labels = (IDataTable)tcaps.Machine.GetOutput("Class labels");
            IDataTable confMatrix = (IDataTable)tcaps.Machine.GetOutput("Confusion matrix");

            PlainDTSaver.Save(labels, "ClassLabels.txt");
            PlainDTSaver.Save(confMatrix, "ConfMatrix.txt");
        }
        public static void MachineTest3BoxB(Project project)
        {
            ConfigBase dc = project.GetConfiguration("GM data loader");
            DataLoaderConfig dcfg = (DataLoaderConfig)dc.Configuration;
            dcfg.InputFileName = dataPath + "iris.dat";

            ConfigBase nnc = project.GetConfiguration("1NN");
            nnc.Inputs.BindSiblingConfig("Dataset", 0, "Dataset");

            SchemeConfig bc = new SchemeConfig();
            bc.DeclareOutput("Dataset", new Type[] { typeof(IDataSet) });
            bc.DeclareOutput("Classifier", new Type[] { typeof(IClassifier) });
            bc.Subconfigurations.Add(0, dc);
            bc.Subconfigurations.Add(1, nnc);
            bc.DeclareOutputBinding("Dataset", 0, "Dataset");
            bc.DeclareOutputBinding("Classifier", 1, "Classifier");
            ConfigBase boxConfBase = project.GetConfiguration(bc);
            Capsule boxCaps = project.Create(boxConfBase);

            ConfigBase tc = project.GetConfiguration("Classification test");
            //ClassTestConfig tcfg = (ClassTestConfig)tc.Configuration;
            tc.Inputs.BindCapsule("Dataset", boxCaps, "Dataset");
            tc.Inputs.BindCapsule("Classifier", boxCaps, "Classifier");
            Capsule tcaps = project.Create(tc);

            project.WaitAll();

            IDataTable labels = (IDataTable)tcaps.Machine.GetOutput("Class labels");
            IDataTable confMatrix = (IDataTable)tcaps.Machine.GetOutput("Confusion matrix");

            PlainDTSaver.Save(labels, "ClassLabels.txt");
            PlainDTSaver.Save(confMatrix, "ConfMatrix.txt");
        }
        public static void MachineTest3BoxC(Project project)
        {
            ConfigBase dc = project.GetConfiguration("GM data loader");
            DataLoaderConfig dcfg = (DataLoaderConfig)dc.Configuration;
            dcfg.InputFileName = dataPath + "iris.dat";

            ConfigBase nnc = project.GetConfiguration("1NN");
            nnc.Inputs.BindSiblingConfig("Dataset", 0, "Dataset");

            ConfigBase tc = project.GetConfiguration("Classification test");
            tc.Inputs.BindSiblingConfig("Dataset", 0, "Dataset");
            tc.Inputs.BindSiblingConfig("Classifier", 1, "Classifier");

            SchemeConfig bc = new SchemeConfig();
            bc.DeclareOutput("Dataset", new Type[] { typeof(IDataSet) });
            bc.DeclareOutput("Classifier", new Type[] { typeof(IClassifier) });
            bc.DeclareOutput("Class labels", new Type[] { typeof(IDataTable) });
            bc.DeclareOutput("Confusion matrix", new Type[] { typeof(IDataTable) });

            bc.Subconfigurations.Add(0, dc);
            bc.Subconfigurations.Add(1, nnc);
            bc.Subconfigurations.Add(2, tc);
            bc.DeclareOutputBinding("Dataset", 0, "Dataset");
            bc.DeclareOutputBinding("Classifier", 1, "Classifier");
            bc.DeclareOutputBinding("Class labels", 2, "Class labels");
            bc.DeclareOutputBinding("Confusion matrix", 2, "Confusion matrix");
            ConfigBase boxConfBase = project.GetConfiguration(bc);
            Capsule boxCaps = project.Create(boxConfBase);

            project.WaitAll();

            IDataTable labels = (IDataTable)boxCaps.Machine.GetOutput("Class labels");
            IDataTable confMatrix = (IDataTable)boxCaps.Machine.GetOutput("Confusion matrix");

            PlainDTSaver.Save(labels, "ClassLabels.txt");
            PlainDTSaver.Save(confMatrix, "ConfMatrix.txt");
        }
        public static void MachineTest3BoxInBox(Project project)
        {
            ConfigBase dc = project.GetConfiguration("GM data loader");
            DataLoaderConfig dcfg = (DataLoaderConfig)dc.Configuration;
            dcfg.InputFileName = dataPath + "iris.dat";

            ConfigBase nnc = project.GetConfiguration("1NN");
            nnc.Inputs.BindSiblingConfig("Dataset", 0, "Dataset");

            ConfigBase tc = project.GetConfiguration("Classification test");
            tc.Inputs.BindSiblingConfig("Dataset", 0, "Dataset");
            tc.Inputs.BindSiblingConfig("Classifier", 1, "Classifier");

            SchemeConfig bc = new SchemeConfig();
            bc.DeclareOutput("Dataset", new Type[] { typeof(IDataSet) });
            bc.DeclareOutput("Classifier", new Type[] { typeof(IClassifier) });
            bc.DeclareOutput("Class labels", new Type[] { typeof(IDataTable) });
            bc.DeclareOutput("Confusion matrix", new Type[] { typeof(IDataTable) });

            bc.Subconfigurations.Add(0, dc);
            bc.Subconfigurations.Add(1, nnc);
            bc.Subconfigurations.Add(2, tc);
            bc.DeclareOutputBinding("Dataset", 0, "Dataset");
            bc.DeclareOutputBinding("Classifier", 1, "Classifier");
            bc.DeclareOutputBinding("Class labels", 2, "Class labels");
            bc.DeclareOutputBinding("Confusion matrix", 2, "Confusion matrix");
            ConfigBase boxConfBase = project.GetConfiguration(bc);

            SchemeConfig bc2 = new SchemeConfig();
            bc2.DeclareOutput("Class labels", new Type[] { typeof(IDataTable) });
            bc2.DeclareOutput("Confusion matrix", new Type[] { typeof(IDataTable) });

            bc2.Subconfigurations.Add(0, boxConfBase);
            bc2.DeclareOutputBinding("Class labels", 0, "Class labels");
            bc2.DeclareOutputBinding("Confusion matrix", 0, "Confusion matrix");
            ConfigBase boxConfBase2 = project.GetConfiguration(bc2);
            Capsule boxCaps = project.Create(boxConfBase2);

            project.WaitAll();

            IDataTable labels = (IDataTable)boxCaps.Machine.GetOutput("Class labels");
            IDataTable confMatrix = (IDataTable)boxCaps.Machine.GetOutput("Confusion matrix");

            PlainDTSaver.Save(labels, "ClassLabels.txt");
            PlainDTSaver.Save(confMatrix, "ConfMatrix.txt");
        }
        public static void MachineTest3TwoBoxInBox(Project project)
        {
            ConfigBase dc = project.GetConfiguration("GM data loader");
            DataLoaderConfig dcfg = (DataLoaderConfig)dc.Configuration;
            dcfg.InputFileName = dataPath + "iris.dat";
            Capsule dcaps = project.Create(dc);

            ConfigBase nnc = project.GetConfiguration("1NN");
            nnc.Inputs.BindParentInput("Dataset", "Dataset");

            SchemeConfig bc = new SchemeConfig();
            bc.DeclareInput("Dataset", new Type[] { typeof(IDataSet) });
            bc.DeclareOutput("Classifier", new Type[] { typeof(IClassifier) });

            bc.Subconfigurations.Add(0, nnc);
            bc.DeclareOutputBinding("Classifier", 0, "Classifier");
            ConfigBase boxConfBase = project.GetConfiguration(bc);
            boxConfBase.Inputs.BindParentInput("Dataset", "Dataset");

            SchemeConfig bc2 = new SchemeConfig();
            bc2.DeclareInput("Dataset", new Type[] { typeof(IDataSet) });
            bc2.DeclareOutput("Classifier", new Type[] { typeof(IClassifier) });

            bc2.Subconfigurations.Add(0, boxConfBase);
            bc2.DeclareOutputBinding("Classifier", 0, "Classifier");
            ConfigBase boxConfBase2 = project.GetConfiguration(bc2);
            boxConfBase2.Inputs.BindCapsule("Dataset", dcaps, "Dataset");
            Capsule boxCaps = project.Create(boxConfBase2);

            ConfigBase tc = project.GetConfiguration("Classification test");
            tc.Inputs.BindParentInput("Dataset", "Dataset");
            tc.Inputs.BindParentInput("Classifier", "Classifier");

            SchemeConfig bc3 = new SchemeConfig();
            bc3.DeclareInput("Dataset", new Type[] { typeof(IDataSet) });
            bc3.DeclareInput("Classifier", new Type[] { typeof(IClassifier) });
            bc3.DeclareOutput("Class labels", new Type[] { typeof(IDataTable) });
            bc3.DeclareOutput("Confusion matrix", new Type[] { typeof(IDataTable) });

            bc3.Subconfigurations.Add(0, tc);
            bc3.DeclareOutputBinding("Class labels", 0, "Class labels");
            bc3.DeclareOutputBinding("Confusion matrix", 0, "Confusion matrix");
            ConfigBase boxConfBase3 = project.GetConfiguration(bc3);
            boxConfBase3.Inputs.BindCapsule("Dataset", dcaps, "Dataset");
            boxConfBase3.Inputs.BindCapsule("Classifier", boxCaps, "Classifier");
            Capsule boxCaps3 = project.Create(boxConfBase3);

            project.WaitAll();

            IDataTable labels = (IDataTable)boxCaps3.Machine.GetOutput("Class labels");
            IDataTable confMatrix = (IDataTable)boxCaps3.Machine.GetOutput("Confusion matrix");

            PlainDTSaver.Save(labels, "ClassLabels.txt");
            PlainDTSaver.Save(confMatrix, "ConfMatrix.txt");
        }
        public static void MachineTest_Repeater(Project project)
        {
            int threadCount = 10;
            int repeatCount = 10;
            int coexistCount = 100;

            ConfigBase dc = project.GetConfiguration("GM data loader");
            DataLoaderConfig dcfg = (DataLoaderConfig)dc.Configuration;
            //dcfg.InputFileName = dataPath + "iris.dat";
            //dcfg.InputFileName = dataPath + "mushroom.dat";
            dcfg.InputFileName = dataPath + "breast-cancer-wisconsin.dat";
            Capsule dcaps = project.Create(dc);

            ConfigBase repeaterConf = project.GetConfiguration("Repeater");

            ConfigBase trainTestDistrBoard =
                project.GetConfiguration("TrainTest Distribution Board");
            TTDistributionBoardConfig ttConfig =
                ((TTDistributionBoardConfig)trainTestDistrBoard.Configuration);
            //ttConfig.SelectionType = SelectionType.Random;
            //ttConfig.SelectionScheme = SelectionScheme.MonteCarlo;
            trainTestDistrBoard.Inputs.BindCapsule("Dataset", dcaps, "Dataset");

            repeaterConf.Subconfigurations[0].Outputs.Bind(
                "Distribution Board", 0, "Distribution Board");
            repeaterConf.Subconfigurations[0].Subconfigurations.Add(0,
                trainTestDistrBoard);

            ((RepeaterConfig)repeaterConf.Configuration).SynchronizeIO(repeaterConf);

            //            ConfigBase oneNNConfig = project.GetConfiguration("Naive Bayesian Classifier");
            ConfigBase oneNNConfig = project.GetConfiguration("1NN");
            oneNNConfig.Inputs.BindParentInput("Dataset", "Training dataset");
            repeaterConf.Subconfigurations[1].Subconfigurations.Add(0, oneNNConfig);

            ConfigBase testConfig =
            project.GetConfiguration("Classification test", "1NN Test");
            //            ConfigBase testConfig = project.GetConfiguration("Classification test");
            testConfig.Inputs.BindParentInput("Dataset", "Test dataset");
            testConfig.Inputs.BindSiblingConfig("Classifier", 0, "Classifier");
            repeaterConf.Subconfigurations[1].Subconfigurations.Add(1, testConfig);

            RepeaterConfig mtc = (RepeaterConfig)repeaterConf.Configuration;
            mtc.CoexistingMachines = coexistCount;
            mtc.Count = repeatCount;

            Capsule repeaterCapsule = project.Create(repeaterConf);

            project.WaitAll();

            Intemi.Query.Query q = new Intemi.Query.Query();
            q.Root = repeaterCapsule;
            q.MainLabel = "Accuracy";
            q.AddMachineConfig(testConfig);
            //q.AddLabels("Accuracy");

            Intemi.Query.Series s = q.Series;
            Console.WriteLine(s);
            Console.WriteLine(s.ToStringAllSeries());
            
            Intemi.Query.Series s2 = s.GetSeries("Fold");
            Console.WriteLine(s2);
            //Console.WriteLine(s.ToStringAllSeries());

            Intemi.Query.Series s3 = s.Group("Repetition");
            //s3 = s.Transform(new Intemi.Query.GroupBy("Repetition"));
            Console.WriteLine(s3.ToStringAllSeries());

            Intemi.Query.Series s4 = s3.Transform(new Intemi.Query.Ungroup());
            Console.WriteLine(s4.ToStringAllSeries());

            Intemi.Query.Series s5 = s.Transform(new Intemi.Query.BasicStatistics());
            Console.WriteLine(s5.ToStringAllSeries());

            Intemi.Query.Series s6 = s3.MAP(new Intemi.Query.BasicStatistics());
            Console.WriteLine(s6.ToStringAllSeries());

            Intemi.Query.Series s7 = s6.Ungroup();
            Console.WriteLine(s7.ToStringAllSeries());

            Intemi.Query.Series s8 = s7.Transform(new Intemi.Query.BasicStatistics());
            Console.WriteLine(s8.ToStringAllSeries());

            Console.WriteLine(s8 - s8.GetSeries("Standard deviation"));

            Console.WriteLine(100*(s8 - s8.GetSeries("Standard deviation")));

            Console.WriteLine((1-s8)*100);
        }
        public static void MachineTestExtTrans(Project project)
        {
            ConfigBase dc = project.GetConfiguration("GM data loader");
            DataLoaderConfig dcfg = (DataLoaderConfig)dc.Configuration;
            dcfg.InputFileName = dataPath + "thyroid-trs.dat";
            Capsule dcaps = project.Create(dc);

            ConfigBase stdc = project.GetConfiguration("Standardization");
            stdc.Inputs.BindCapsule("Dataset", dcaps, "Dataset");
            Capsule stdcaps = project.Create(stdc);

            ConfigBase cc = project.GetConfiguration("Naive Bayesian Classifier");
            cc.Inputs.BindCapsule("Dataset", stdcaps, "Dataset");
            Capsule cccaps = project.Create(cc);

            ConfigBase tdc = project.GetConfiguration("GM data loader");
            DataLoaderConfig tdcfg = (DataLoaderConfig)tdc.Configuration;
            tdcfg.InputFileName = dataPath + "thyroid-tes.dat";
            //tdcfg.InputFileName = dataPath + "thyroid-trs.dat";
            Capsule tdcaps = project.Create(tdc);

            ConfigBase etc = project.GetConfiguration("External transformation");
            etc.Inputs.BindCapsule("Dataset", tdcaps, "Dataset");
            etc.Inputs.BindCapsule("Data transformer", stdcaps, "Standardizer");
            Capsule etccaps = project.Create(etc);

            ConfigBase tc = project.GetConfiguration("Classification test");
            tc.Inputs.BindCapsule("Dataset", etccaps, "Transformed data");
            tc.Inputs.BindCapsule("Classifier", cccaps, "Classifier");
            Capsule tcaps = project.Create(tc);

            project.WaitAll();

            IDataTable trnDataStd = (IDataTable)stdcaps.Machine.GetOutput("Dataset");
            IDataTable tstDataStd = (IDataTable)etccaps.Machine.GetOutput("Transformed data");
            PlainDTSaver.Save(trnDataStd, "trnDataStd.txt");
            PlainDTSaver.Save(tstDataStd, "tstDataStd.txt");

            IDataTable labels = (IDataTable)tcaps.Machine.GetOutput("Class labels");
            IDataTable confMatrix = (IDataTable)tcaps.Machine.GetOutput("Confusion matrix");

            PlainDTSaver.Save(labels, "ClassLabels.txt");
            PlainDTSaver.Save(confMatrix, "ConfMatrix.txt");
        }
        public static void MachineTestTrainAndTest(Project project, int k)
        {
            ConfigBase dc = project.GetConfiguration("GM data loader");
            DataLoaderConfig dcfg = (DataLoaderConfig)dc.Configuration;
            dcfg.InputFileName = dataPath + "thyroid-trs .dat";
            //dcfg.InputFileName = dataPath + "iris.dat";
            Capsule dcaps = project.Create(dc);

            ConfigBase cc = project.GetConfiguration("kNN");
            //ConfigBase cc = project.GetConfiguration("1NN");
            ((kNNConfig)cc.Configuration).K = k;
            //ConfigBase cc = project.GetConfiguration("Naive Bayesian Classifier");
            cc.Inputs.BindCapsule("Dataset", dcaps, "Dataset");
            Capsule cccaps = project.Create(cc);

            ConfigBase tdc = project.GetConfiguration("GM data loader");
            DataLoaderConfig tdcfg = (DataLoaderConfig)tdc.Configuration;
            tdcfg.InputFileName = dataPath + "thyroid-tes.dat";
            //tdcfg.InputFileName = dataPath + "iris.dat";
            Capsule tdcaps = project.Create(tdc);

            ConfigBase tc = project.GetConfiguration("Classification test");
            tc.Inputs.BindCapsule("Dataset", dcaps, "Dataset");
            tc.Inputs.BindCapsule("Classifier", cccaps, "Classifier");
            Capsule tcaps = project.Create(tc);

            ConfigBase t2c = project.GetConfiguration("Classification test");
            t2c.Inputs.BindCapsule("Dataset", tdcaps, "Dataset");
            t2c.Inputs.BindCapsule("Classifier", cccaps, "Classifier");
            Capsule t2caps = project.Create(t2c);

            project.WaitAll();

            Console.WriteLine("Training set accuracy:\t{0}", (double)tcaps.Result("Accuracy"));
            Console.WriteLine("Test set accuracy:\t{0}", (double)t2caps.Result("Accuracy"));

            double acc = (double)t2caps.Machine.ResultsRepository["Accuracy"];
            Console.WriteLine("Accuracy: {0}", acc);
            IDataTable labels = (IDataTable)tcaps.Machine.GetOutput("Class labels");
            IDataTable confMatrix = (IDataTable)tcaps.Machine.GetOutput("Confusion matrix");

            PlainDTSaver.Save(labels, "ClassLabels-trn.txt");
            PlainDTSaver.Save(confMatrix, "ConfMatrix-trn.txt");

            labels = (IDataTable)t2caps.Machine.GetOutput("Class labels");
            confMatrix = (IDataTable)t2caps.Machine.GetOutput("Confusion matrix");

            PlainDTSaver.Save(labels, "ClassLabels-tst.txt");
            PlainDTSaver.Save(confMatrix, "ConfMatrix-tst.txt");
        }
        public static void MachineTestFeatSel(Project project)
        {
            ConfigBase dc = project.GetConfiguration("GM data loader");
            DataLoaderConfig dcfg = (DataLoaderConfig)dc.Configuration;
            //dcfg.InputFileName = dataPath + "thyroid-trs.dat";
            dcfg.InputFileName = dataPath + "mushroom.dat";
            //dcfg.InputFileName = dataPath + "biesiada2.dat";
            Capsule dcaps = project.Create(dc);

            ConfigBase frc = project.GetConfiguration("Battiti ranking");
            //ConfigBase frc = project.GetConfiguration("Information ranking");
            //ConfigBase frc = project.GetConfiguration("F-Score ranking");
            //ConfigBase frc = project.GetConfiguration("CC ranking");
            //RankingCCConfig frcfg = (RankingCCConfig)frc.Configuration;
            RankingBattitiConfig frcfg = (RankingBattitiConfig)frc.Configuration;
            //RankingInfConfig frcfg = (RankingInfConfig)frc.Configuration;
            //RankingFScoreConfig frcfg = (RankingFScoreConfig)frc.Configuration;
            //frcfg.Weighted = false;
            //frcfg.SelectByThreshold = true;
            //frcfg.SelectionThreshold = 0.2;
            frcfg.SelectionSize = 22;
            frcfg.Beta = .5;
            frc.Inputs.BindCapsule("Dataset", dcaps, "Dataset");
            Capsule frcaps = project.Create(frc);

            ConfigBase fsc = project.GetConfiguration("Feature selector");
            fsc.Inputs.BindCapsule("Dataset", dcaps, "Dataset");
            fsc.Inputs.BindCapsule("Feature Ranking", frcaps, "Feature Ranking");
            Capsule fscaps = project.Create(fsc);

            project.WaitAll();

            IDataTable ccSelData = (IDataTable)fscaps.Machine.GetOutput("Data Table");
            PlainDTSaver.Save(ccSelData, "ccSelData.txt");

            IFeatureRanking fr = (IFeatureRanking)frcaps.Machine.GetOutput("Feature Ranking");
            IFeaturesInfo fi = ((IDataTable)dcaps.Machine.GetOutput("Dataset")).FeaturesInfo;
            Console.WriteLine("Rank\tCC\tFeature");
            for (int i = 0; i < fr.RankingSize; i++)
                Console.WriteLine("{0}\t{1}\t{2}", i + 1, fr.Value(i), fi[fr.FeatureId(i)].Name);
            Console.WriteLine("Selection: {0}", fr.SelectionSize);
        }
        public static void MachineTest_CV(Project project)
        {
            ConfigBase dc = project.GetConfiguration("GM data loader");
            DataLoaderConfig dcfg = (DataLoaderConfig)dc.Configuration;
            //dcfg.InputFileName = dataPath + "breast-cancer-wisconsin.dat";
            dcfg.InputFileName = dataPath + "thyroid-trs.dat";
            Capsule dcaps = project.Create(dc);

            ConfigBase cConfig =
            //    project.GetConfiguration("Naive Bayesian Classifier");
                project.GetConfiguration("kNN");
            ((kNNConfig)cConfig.Configuration).K = 5;

            CITools.CVTest(cConfig, project, dcaps, "Dataset", 10, 10, 10);
        }
        public static void MachineTest_CV2(Project project)
        {
            ConfigBase dc = project.GetConfiguration("GM data loader");
            DataLoaderConfig dcfg = (DataLoaderConfig)dc.Configuration;
            dcfg.InputFileName = dataPath + "breast-cancer-wisconsin.dat";
            //dcfg.InputFileName = dataPath + "ionosphere-ALL.dat";

            Capsule dcaps = project.Create(dc);

            ConfigBase nbConfig =
                project.GetConfiguration("Naive Bayesian Classifier");

            CITools.CV cv = new CITools.CV(nbConfig, project, dcaps, "Dataset", 10, 10, 100);
            //cv.AddCommentatorToClassificationTest(new Intemi.Query.ConfusionMatrixCommentator());
            Intemi.Query.Series s = cv.Run();
            Console.WriteLine("Average Accuracy \n{0}", s.ToStringAllSeries());

            Intemi.Query.ApplyCommentator applyComm = new Intemi.Query.ApplyCommentator();
            applyComm.Commentators.Add(new Intemi.Query.ConfusionMatrixCommentator());
            applyComm.MachineConfigs.Add(cv.ConfigBaseOfClassificationTest());
            applyComm.Root = cv.Capsule;
            applyComm.Run();
            Intemi.Query.Query q = new Intemi.Query.Query();
            q.AddMachineConfig(cv.ConfigBaseOfClassificationTest());
            q.Root = cv.Capsule;
            Intemi.Query.Series s2 = q.Series;
            Intemi.Query.Series s3;
            s3 = s2.GetSeries("Sensitivity").Transform(new Intemi.Query.BasicStatistics());
            Console.WriteLine("Sensitivity {0}", s3);
            s3 = s2.GetSeries("Specificity").Transform(new Intemi.Query.BasicStatistics());
            Console.WriteLine("Specificity {0}", s3);
        }
        public static void MachineTest_CVwithResultsExplorer(Project project)
        {
            ConfigBase dc = project.GetConfiguration("GM data loader");
            DataLoaderConfig dcfg = (DataLoaderConfig)dc.Configuration;
            dcfg.InputFileName = dataPath + "breast-cancer-wisconsin.dat";
            Capsule dcaps = project.Create(dc);

            ConfigBase nbConfig =
                project.GetConfiguration("Naive Bayesian Classifier");
            CITools.CV cv = new CITools.CV(nbConfig, project, dcaps, "Dataset", 10, 10, 2);

            cv.Run();

            Intemi.Query.Query q = new Intemi.Query.Query();
            q.Root = cv.Capsule;
            q.AddMachineConfig(cv.ConfigBaseOfClassificationTest());
            q.MainLabel = "Accuracy";
            Intemi.Query.Series s = q.Series;
            Intemi.Query.Series s2 = s.Group("Repetition");
            Intemi.Query.Series s3 = s2.MAP(new Intemi.Query.BasicStatistics());
            Console.WriteLine("Accuracies in subsequent CVs {0}", s3.ToStringAllSeries());

            s2 = s.Group("Repetition");
            s3 = s2.MAP(new Intemi.Query.BasicStatistics());
            Console.WriteLine("Accuracies in subsequent folds of all CVs {0}", s3.ToStringAllSeries());

        }
        public static void MachineTest_CV_Of_TransAndClass(Project project)
        {
            ConfigBase dc = project.GetConfiguration("GM data loader");
            DataLoaderConfig dcfg = (DataLoaderConfig)dc.Configuration;
            dcfg.InputFileName = dataPath + "breast-cancer-wisconsin.dat";
            Capsule dcaps = project.Create(dc);

            ConfigBase stdc = project.GetConfiguration("Standardization ToyMachine");
            stdc.Inputs.BindParentInput("Dataset", "Dataset");

            ConfigBase nnc = project.GetConfiguration("kNN");
            nnc.Inputs.BindSiblingConfig("Dataset", 0, "Dataset");

            SchemeConfig bc = new SchemeConfig();
            bc.DeclareInput("Dataset", new Type[] { typeof(IDataTable) });
            bc.DeclareOutput("Classifier", new Type[] { typeof(IClassifier) });
            bc.DeclareOutput("Transformer", new Type[] { typeof(IDataSetTransformer) });
            bc.Subconfigurations.Add(0, stdc);
            bc.Subconfigurations.Add(1, nnc);
            bc.DeclareOutputBinding("Classifier", 1, "Classifier");
            bc.DeclareOutputBinding("Transformer", 0, "Standardizer");
            ConfigBase boxConf = project.GetConfiguration(bc);

            CITools.CVTest(boxConf, project, dcaps, "Dataset", 10, 10, 1);
        }
        public static void MachineTest_CV_Of_RankingFS_And_Class(Project project)
        {
            ConfigBase dc = project.GetConfiguration("GM data loader");
            DataLoaderConfig dcfg = (DataLoaderConfig)dc.Configuration;
            //dcfg.InputFileName = dataPath + "breast-cancer-wisconsin.dat";
            dcfg.InputFileName = dataPath + "mushroom.dat";
            Capsule dcaps = project.Create(dc);

            ConfigBase rankingConf = project.GetConfiguration("F-Score ranking");
            //ConfigBase rankingConf = project.GetConfiguration("CC ranking");
            rankingConf.Inputs.BindParentInput("Dataset", "Dataset");
            ((RankingFScoreConfig)rankingConf.Configuration).SelectionSize = 5; //!!!

            ConfigBase fsConf = project.GetConfiguration("Feature selector");
            fsConf.Inputs.BindParentInput("Dataset", "Dataset");
            fsConf.Inputs.BindSiblingConfig("Feature Ranking", 0, "Feature Ranking");

            ConfigBase nnc = project.GetConfiguration("Naive Bayesian Classifier");
            //ConfigBase nnc = project.GetConfiguration("kNN");
            //ConfigBase nnc = project.GetConfiguration("One_NN");
            //ConfigBase nnc = project.GetConfiguration("1NN");
            //((kNNConfig)nnc.Configuration).K = 5; //!!!
            nnc.Inputs.BindSiblingConfig("Dataset", 2, "Data Table");

            SchemeConfig bc = new SchemeConfig();
            bc.DeclareInput("Dataset", new Type[] { typeof(IDataTable) });
            bc.DeclareOutput("Classifier", new Type[] { typeof(IClassifier) });
            bc.DeclareOutput("Transformer", new Type[] { typeof(IDataSetTransformer) });
            bc.Subconfigurations.Add(0, rankingConf);
            bc.Subconfigurations.Add(1, nnc);
            bc.Subconfigurations.Add(2, fsConf);
            bc.DeclareOutputBinding("Classifier", 1, "Classifier");
            bc.DeclareOutputBinding("Transformer", 2, "Feature Selector");
            ConfigBase boxConf = project.GetConfiguration(bc);

            CITools.CVTest(boxConf, project, dcaps, "Dataset", 10, 10, 1);
        }

        public static void DiscretizerTest(Project project)
        {
            ConfigBase dc = project.GetConfiguration("GM data loader");
            DataLoaderConfig dcfg = (DataLoaderConfig)dc.Configuration;
            dcfg.InputFileName = dataPath + "iris.dat";
            //dcfg.InputFileName = dataPath + "mushroom.dat";
            //dcfg.InputFileName = dataPath + "thyroid-trs.dat";
            Capsule dcaps = project.Create(dc);

            ConfigBase discConf = project.GetConfiguration("Equal Width Discretizer");
            EqWDiscretizerConfig discConf_c = (EqWDiscretizerConfig)(discConf.Configuration);
            discConf_c.K = 3;
            discConf.Inputs.BindCapsule("Dataset", dcaps, "Dataset");
            Capsule discCaps = project.Create(discConf);
            
            ConfigBase cc = project.GetConfiguration("kNN");
            //ConfigBase cc = project.GetConfiguration("Naive Bayesian Classifier");
            cc.Inputs.BindCapsule("Dataset", discCaps, "Dataset");
            Capsule cccaps = project.Create(cc);

            ConfigBase tc = project.GetConfiguration("Classification test");
            //ClassTestConfig tcfg = (ClassTestConfig)tc.Configuration;
            tc.Inputs.BindCapsule("Dataset", discCaps, "Dataset");
            tc.Inputs.BindCapsule("Classifier", cccaps, "Classifier");
            Capsule tcaps = project.Create(tc);

            project.WaitAll();

            IDataTable data = (IDataTable)discCaps.Machine.GetOutput("Dataset");
            PlainDTSaver.Save(data, "iris3k.txt");

            IDataTable labels = (IDataTable)tcaps.Machine.GetOutput("Class labels");
            IDataTable confMatrix = (IDataTable)tcaps.Machine.GetOutput("Confusion matrix");

            PlainDTSaver.Save(labels, "ClassLabels.txt");
            PlainDTSaver.Save(confMatrix, "ConfMatrix.txt");
        }

        static void W(string title, string seriesSTR)
        {
            Console.WriteLine("{0}:\n{1}\n", title, seriesSTR);
        }
        static void W(string title, Series s)
        {
            W(title, s.ToStringAllSeries());
        }
        public static void Repeater_CV_with_KNN_and_NB(Project project)
        {
            ConfigBase dc = project.GetConfiguration("GM data loader");
            DataLoaderConfig dcfg = (DataLoaderConfig)dc.Configuration;
            //dcfg.InputFileName = dataPath + "iris.dat";
            //dcfg.InputFileName = dataPath + "wine.dat";
            dcfg.InputFileName = dataPath + "breast-cancer-wisconsin.dat";
            Capsule dcaps = project.Create(dc);

            ConfigBase mtConfigBase = 
                CITools.Repeater_CVConfig(project, dcaps, "Dataset");
            ((RepeaterConfig)mtConfigBase.Configuration).Count = 10;
            
            // kNN
            ConfigBase kNNConf = project.GetConfiguration("1NN");
            kNNConf.Inputs.BindParentInput("Dataset", "Training dataset");
            // Naive Bayes
            ConfigBase NBConf = project.GetConfiguration("Naive Bayesian Classifier");
            NBConf.Inputs.BindParentInput("Dataset", "Training dataset");

            // test of kNN
            ConfigBase kNNtestConfig =
                project.GetConfiguration("Classification test", "1NN Test");
            kNNtestConfig.Inputs.BindParentInput("Dataset", "Test dataset");
            kNNtestConfig.Inputs.BindSiblingConfig("Classifier", 0, "Classifier");
            // test of NB
            ConfigBase NBtestConfig =
                project.GetConfiguration("Classification test", "NB Test");
            NBtestConfig.Inputs.BindParentInput("Dataset", "Test dataset");
            NBtestConfig.Inputs.BindSiblingConfig("Classifier", 1, "Classifier");

            mtConfigBase.Subconfigurations[1].Subconfigurations.Add(0, kNNConf);
            mtConfigBase.Subconfigurations[1].Subconfigurations.Add(1, NBConf);
            mtConfigBase.Subconfigurations[1].Subconfigurations.Add(2, kNNtestConfig);
            mtConfigBase.Subconfigurations[1].Subconfigurations.Add(3, NBtestConfig);

            ((TTDistributionBoardConfig)mtConfigBase.Subconfigurations[0].Subconfigurations[0].Configuration).Count = 5;
            Capsule mt = project.Create(mtConfigBase);
            project.WaitAll();


            Console.WriteLine("------------------------- 1 -- CV of kNN");
            Query q = new Query();
            q.Root = mt;
            q.AddMachineConfig(kNNtestConfig);
            //q.AddLabels("Accuracy");
            q.MainLabel = "Accuracy";

            Series s = q.Series;
            Console.WriteLine("s: {0}\n\n", s);
            Console.WriteLine("s: {0}\n", s.ToStringAllSeries());

            s = s.Transform(new BasicStatistics());
            Console.WriteLine("kNN|BasicStatistics:\n{0}\n", s);
            Console.WriteLine("kNN|BasicStatistics:\n{0}\n", s.ToStringAllSeries());

            double acc = (double)s["Mean", 0]; //lub: = (double)s2.Items[0]["Mean"];
            Console.WriteLine("Acc-std = {0}\n", s - s.GetSeries("Standard deviation"));


            Series seriesSet = ((ISeriesTransformer)new SetOfSeries()).Transform(
                s, s - s.GetSeries("Standard deviation"));
            Console.WriteLine("SetOfSeries = {0}\n", seriesSet);

            Series s2;
            /*Console.WriteLine("------------------------- 2 -- Ttest of kNN & NB");
            q = new Query();
            q.Root = mt;
            q.MachineConfigs.Add(NBtestConfig);
            q.MainLabel = "Accuracy";
            
            s2 = q.Series;
            s2 = s2.Transform(new BasicStatistics());
            W("NB|BasicStatistics", s2);
            
            ISeriesTransformer tt = new TTestPaired();
            s = tt.Transform(s, s2);
            W("TTestPaired: ", s);
            */
            Console.WriteLine("------------------------- 2 -- Ttest!! of kNN & NB");
            q = new Query();
            q.Root = mt;
            q.AddMachineConfig(kNNtestConfig);
            q.MainLabel = "Accuracy";
            s = q.Series;

            q = new Query();
            q.Root = mt;
            q.AddMachineConfig(NBtestConfig);
            q.MainLabel = "Accuracy";
            s2 = q.Series;
            W("N Test", (new NTest()).Transform(s,s2));
            s = s.Group("Repetition").MAP(new BasicStatistics()).Ungroup();
            s2 = s2.Group("Repetition").MAP(new BasicStatistics()).Ungroup();

            W("kNN", s.Transform(new BasicStatistics()));
            W("NB", s2.Transform(new BasicStatistics())); 
            W("s1-s2", s - s2);
            
            Series sx;
            sx = (new TTest()).Transform(s, s2);
            W("TTest", sx);
            sx = (new TUTest()).Transform(s, s2);
            W("TUTest", sx);
            sx = (new TTestPaired()).Transform(s, s2);
            W("Paired TTest: ", sx);
            
            
            Console.WriteLine("------------------------- 3 Query of KNN and NB --");
            q = new Query();
            q.Root = mt;
            q.AddMachineConfig(kNNtestConfig, NBtestConfig);
            q.MainLabel = "Accuracy";

            s = q.Series;

            s = s.Group(Series.FamilyConfig);
            s = s.MAP(new BasicStatistics());
            W("S|G|M:", s.ToStringAllSeries());
            s = s.Ungroup();
            W("[Group|MAP|UnGroup][kNN&NB]", s.ToStringAllSeries());

            Console.WriteLine("------------------------- 3 cd. --");
            s = q.Series;
            s = s.Group(Series.FamilyConfig);
            s = s.MAP(new Group("Repetition"));
            s = s.MAP(new MAP(new BasicStatistics()));
            W("Group-family | Group-rep | BS", s.ToStringAllSeries());

            s = s.MAP(new Ungroup());

            s = s.MAP(new BasicStatistics());
            s = s.Ungroup();
            W("Group-family | Group-rep | BS | UnGroup | BS", s.ToStringAllSeries());

            Console.WriteLine("------------------------- 2 --");
            Console.WriteLine("------------------------- 2 --");
            Console.WriteLine("------------------------- 2 --");


        }
        public static void McNemar_Of_single_KNN_and_NB(Project project)
        {
            ConfigBase dc = project.GetConfiguration("GM data loader");
            DataLoaderConfig dcfg = (DataLoaderConfig)dc.Configuration;
            dcfg.InputFileName = dataPath + "thyroid-TRS.dat";
            Capsule dcaps = project.Create(dc);
            ConfigBase dc2 = project.GetConfiguration("GM data loader");
            DataLoaderConfig dcfg2 = (DataLoaderConfig)dc2.Configuration;
            dcfg2.InputFileName = dataPath + "thyroid-TES.dat";
            //dcfg2.InputFileName = dataPath + "iris.dat";
            Capsule dcaps2 = project.Create(dc2);

            // kNN
            ConfigBase kNNConf = project.GetConfiguration("kNN");
            kNNConfig knnc = (kNNConfig)kNNConf.Configuration;
            knnc.K = 2;
            kNNConf.Inputs.BindCapsule("Dataset", dcaps, "Dataset");
            Capsule kNN = project.Create(kNNConf);
            // Naive Bayes
            //ConfigBase NBConf = project.GetConfiguration("Naive Bayesian Classifier");
            ConfigBase NBConf = project.GetConfiguration("kNN");
            kNNConfig knnc2 = (kNNConfig)NBConf.Configuration;
            knnc2.K = 23;
            NBConf.Inputs.BindCapsule("Dataset", dcaps, "Dataset");
            Capsule NB = project.Create(NBConf);

            // test of kNN
            ConfigBase kNNtestConfig =
                project.GetConfiguration("Classification test", "1NN Test");
            kNNtestConfig.Inputs.BindCapsule("Dataset", dcaps2, "Dataset");
            kNNtestConfig.Inputs.BindCapsule("Classifier", kNN, "Classifier");
            kNNtestConfig.DeclareCommentator(new CorrectnessCommentator());
            // test of NB
            ConfigBase NBtestConfig =
                project.GetConfiguration("Classification test", "NB Test");
            NBtestConfig.Inputs.BindCapsule("Dataset", dcaps2, "Dataset");
            NBtestConfig.Inputs.BindCapsule("Classifier", NB, "Classifier");
            NBtestConfig.DeclareCommentator(new CorrectnessCommentator());

            Capsule kNNTest = project.Create(kNNtestConfig);
            Capsule NBTest = project.Create(NBtestConfig);
            project.WaitAll();

            Series s0 = kNNTest.Machine.ResultsRepository.GetAsSeries("Correctness");
            Series s1 = NBTest.Machine.ResultsRepository.GetAsSeries("Correctness");
            W("s0", s0);
            W("s1", s1);
            s0 = s0.Transform(new Unpack());
            s1 = s1.Transform(new Unpack());
            W("s0unpack", s0);
            W("s1unpack", s1);

            ISeriesTransformer mnt = new McNemar();
            Series s2 = mnt.Transform(s0, s1);
            W("McNemar of single kNN & NB", s2);
        }
        public static void McNemar_from_CV_with_KNN_and_NB(Project project)
        {
            ConfigBase dc = project.GetConfiguration("GM data loader");
            DataLoaderConfig dcfg = (DataLoaderConfig)dc.Configuration;
            //dcfg.InputFileName = dataPath + "iris.dat";
            dcfg.InputFileName = dataPath + "hepatitis.dat";
            //dcfg.InputFileName = dataPath + "wine.dat";
            //dcfg.InputFileName = dataPath + "breast-cancer-wisconsin.dat";
            Capsule dcaps = project.Create(dc);

            ConfigBase mtConfigBase =
                CITools.Repeater_CVConfig(project, dcaps, "Dataset");
            ((RepeaterConfig)mtConfigBase.Configuration).Count = 10;

            // kNN
            ConfigBase kNNConf = project.GetConfiguration("1NN");
            kNNConf.Inputs.BindParentInput("Dataset", "Training dataset");
            // Naive Bayes
            ConfigBase NBConf = project.GetConfiguration("Naive Bayesian Classifier");
            NBConf.Inputs.BindParentInput("Dataset", "Training dataset");

            // test of kNN
            ConfigBase kNNtestConfig =
                project.GetConfiguration("Classification test", "1NN Test");
            kNNtestConfig.Inputs.BindParentInput("Dataset", "Test dataset");
            kNNtestConfig.Inputs.BindSiblingConfig("Classifier", 0, "Classifier");
            kNNtestConfig.DeclareCommentator(new CorrectnessCommentator());
            // test of NB
            ConfigBase NBtestConfig =
                project.GetConfiguration("Classification test", "NB Test");
            NBtestConfig.Inputs.BindParentInput("Dataset", "Test dataset");
            NBtestConfig.Inputs.BindSiblingConfig("Classifier", 1, "Classifier");
            NBtestConfig.DeclareCommentator(new CorrectnessCommentator());

            mtConfigBase.Subconfigurations[1].Subconfigurations.Add(0, kNNConf);
            mtConfigBase.Subconfigurations[1].Subconfigurations.Add(1, NBConf);
            mtConfigBase.Subconfigurations[1].Subconfigurations.Add(2, kNNtestConfig);
            mtConfigBase.Subconfigurations[1].Subconfigurations.Add(3, NBtestConfig);

            Capsule mt = project.Create(mtConfigBase);
            mt.WaitFor();

            Query q = new Query();
            q.Root = mt;
            q.AddMachineConfig(kNNtestConfig, NBtestConfig);
            q.MainLabel = "Correctness";
            Series s = q.Series;

            s = s.Group(Series.FamilyConfig).MAP(new Unpack());
            ISeriesTransformer mcNemarST = new McNemar();
            s = mcNemarST.Transform((Series)s[0], (Series)s[1]);
            W("McNemar", s);
        }

        public static void Repeater_MannWhitney_and_Wilcoxon(Project project)
        {
            IDictionary d = Environment.GetEnvironmentVariables(EnvironmentVariableTarget.User);
            ConfigBase dc = project.GetConfiguration("GM data loader");
            DataLoaderConfig dcfg = (DataLoaderConfig)dc.Configuration;
            dcfg.InputFileName = dataPath + "iris.dat";
            //dcfg.InputFileName = dataPath + "wine.dat";
            //dcfg.InputFileName = dataPath + "breast-cancer-wisconsin.dat";
            Capsule dcaps = project.Create(dc);

            ConfigBase mtConfigBase =
                CITools.Repeater_CVConfig(project, dcaps, "Dataset");
            ((RepeaterConfig)mtConfigBase.Configuration).Count = 10;

            // kNN
            ConfigBase kNNConf = project.GetConfiguration("Naive Bayesian Classifier");
            kNNConf.Inputs.BindParentInput("Dataset", "Training dataset");
            // Naive Bayes
            ConfigBase NBConf = project.GetConfiguration("Naive Bayesian Classifier");
            NBConf.Inputs.BindParentInput("Dataset", "Training dataset");

            // test of kNN
            ConfigBase kNNtestConfig =
                project.GetConfiguration("Classification test", "1NN Test");
            kNNtestConfig.Inputs.BindParentInput("Dataset", "Test dataset");
            kNNtestConfig.Inputs.BindSiblingConfig("Classifier", 0, "Classifier");
            kNNtestConfig.DeclareCommentator(new CorrectnessCommentator());
            // test of NB
            ConfigBase NBtestConfig =
                project.GetConfiguration("Classification test", "NB Test");
            NBtestConfig.Inputs.BindParentInput("Dataset", "Test dataset");
            NBtestConfig.Inputs.BindSiblingConfig("Classifier", 1, "Classifier");
            NBtestConfig.DeclareCommentator(new CorrectnessCommentator());

            mtConfigBase.Subconfigurations[1].Subconfigurations.Add(0, kNNConf);
            mtConfigBase.Subconfigurations[1].Subconfigurations.Add(1, NBConf);
            mtConfigBase.Subconfigurations[1].Subconfigurations.Add(2, kNNtestConfig);
            mtConfigBase.Subconfigurations[1].Subconfigurations.Add(3, NBtestConfig);

            ((TTDistributionBoardConfig)mtConfigBase.Subconfigurations[0].Subconfigurations[0].Configuration).Count = 5;
            Capsule mt = project.Create(mtConfigBase);
            project.WaitAll();

            Query q; Series s, s2;
            Console.WriteLine("------------------------- Queries");
            q = new Query();
            q.Root = mt;
            q.AddMachineConfig(kNNtestConfig);
            q.MainLabel = "Accuracy";
            s = q.Series;

            q = new Query();
            q.Root = mt;
            q.AddMachineConfig(NBtestConfig);
            q.MainLabel = "Accuracy";
            s2 = q.Series;

            Console.WriteLine("------------------------- 2 -- BASIC STAT of kNN & NB");
            
            W("N Test", (new NTest()).Transform(s, s2));
            s = s.Group("Repetition").MAP(new BasicStatistics()).Ungroup();
            s2 = s2.Group("Repetition").MAP(new BasicStatistics()).Ungroup();

            W("kNN", s.Transform(new BasicStatistics()));
            W("NB", s2.Transform(new BasicStatistics()));
            W("s1-s2", s - s2);

            Console.WriteLine("------------------------- 2 -- Ttest!! of kNN & NB");
            Series sx;
            sx = (new TTest()).Transform(s, s2);
            W("TTest", sx);
            sx = (new TUTest()).Transform(s, s2);
            W("TUTest", sx);
            sx = (new TTestPaired()).Transform(s, s2);
            W("Paired TTest", sx);

            Console.WriteLine("------------------------- 2 -- MannWhitneyTest!! of kNN & NB");
            sx = (new MannWhitneyTest()).Transform(s, s2);
            W("MannWhitneyTest", sx);

            Console.WriteLine("------------------------- 2 -- WilcoxonSignedRankTest!! of kNN & NB");
            sx = (new WilcoxonSignedRankTest()).Transform(s, s2);
            W("WilcoxonSignedRankTest", sx);

            Console.WriteLine("------------------------- 2 -- McNemar!! of kNN & NB");
            q = new Query();
            q.Root = mt;
            q.AddMachineConfig(kNNtestConfig, NBtestConfig);
            q.MainLabel = "Correctness";
            sx = q.Series;

            sx = sx.Group(Series.FamilyConfig);
            sx = sx.MAP(new Unpack());
            ISeriesTransformer mcNemarST = new McNemar();
            sx = mcNemarST.Transform((Series)sx[0], (Series)sx[1]);
            W("McNemar:", sx);


            Console.WriteLine("------------------------- 2 -- Paired TTest of ACC-Std");
            sx = (new TTestPaired()).Transform(
                s - s.GetSeries("Standard deviation"), 
                s2 - s2.GetSeries("Standard deviation"));
            W("Paired TTest of ACC-Std", sx);

            Console.WriteLine("------------------------- 2 -- method 2");
            q = new Query();
            q.Root = mt;
            q.AddMachineConfig(kNNtestConfig, NBtestConfig);
            q.MainLabel = "Accuracy";
            s = q.Series;

            s = s.Group(Series.FamilyConfig).MAP(new Group("Repetition"));
            s = s.MAP(new MAP(new BasicStatistics()));
            s = s.MAP(new Ungroup());
            ISeriesTransformer st = new ExpresionOnSeries(ExpresionOperator.sub);
            ISeriesTransformer map = new MAP(st);

            s = map.Transform(s, s.MAP(new GetSeries("Standard deviation")));
            sx = (new TTestPaired()).Transform((Series)s[0], (Series)s[1]);
            W("Paired TTest of ACC-Std", sx);
        }

        public static void MachineTest_SSVDT(Project project)
        {
            ConfigBase dc = project.GetConfiguration("GM data loader");
            DataLoaderConfig dcfg = (DataLoaderConfig)dc.Configuration;
            dcfg.InputFileName = dataPath + "thyroid-trs.dat";
            Capsule dcaps = project.Create(dc);

            ConfigBase cc = project.GetConfiguration("Validated SSV decision tree");
            cc.Inputs.BindCapsule("Dataset", dcaps, "Dataset");
            Capsule ccaps = project.Create(cc);

            ConfigBase testdc = project.GetConfiguration("GM data loader");
            DataLoaderConfig vdcfg = (DataLoaderConfig)testdc.Configuration;
            vdcfg.InputFileName = dataPath + "thyroid-tes.dat";
            Capsule testdcaps = project.Create(testdc);

            ConfigBase trnc = project.GetConfiguration("Classification test");
            trnc.Inputs.BindCapsule("Dataset", dcaps, "Dataset");
            trnc.Inputs.BindCapsule("Classifier", ccaps, "Classifier");
            Capsule trn = project.Create(trnc);

            ConfigBase tstc = project.GetConfiguration("Classification test");
            tstc.Inputs.BindCapsule("Dataset", testdcaps, "Dataset");
            tstc.Inputs.BindCapsule("Classifier", ccaps, "Classifier");
            Capsule tst = project.Create(tstc);

            project.WaitAll();

            Console.WriteLine("Training set accuracy:\t{0}", (double)trn.Result("Accuracy"));
            Console.WriteLine("Test set accuracy:\t{0}", (double)tst.Result("Accuracy"));

            ITree tree = ccaps.Machine.GetOutput("Tree") as ITree;
            Console.WriteLine("\nThe tree:");
            Intemi.Classifiers.DT.Tools.PrintTree(tree.Root, "  ");
            Console.WriteLine();
        }

        public static void ShowIO(IOInfo[] ioinfo, string caption)
        {
            Console.WriteLine("\t{0}:", caption);
            if (ioinfo == null)
                Console.WriteLine("\t\tnone");
            else
            {
                foreach (IOInfo info in ioinfo)
                {
                    Console.Write("\t\t{0} :", info.name);
                    foreach (Type t in info.types)
                        Console.Write(" {0}", t.Name);
                    Console.WriteLine();
                }
            }
        }
        public static void ShowAvailableMachines(Project project, bool showInputs, bool showOutputs)
        {
            MachineInfo[] mi = project.AvailableMachines();
            foreach (MachineInfo m in mi)
            {
                Console.WriteLine(m.name);
                Console.WriteLine("\tMachine type: {0}", m.machineType.Name);
                Console.WriteLine("\tConfig type: {0}", m.configType.Name);
                if (showInputs)
                    ShowIO(m.inputs, "Inputs");
                if (showOutputs)
                    ShowIO(m.outputs, "Outputs");
            }
        }
    }

}
