using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using Intemi;

namespace TutorialVPrg
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            ViewData();
        }

        private void ViewData()
        {
            Project project = null;
            try
            {
                project = new Project(new LocalTaskMgr());
                //project.LoadAssembly("TutorialPrg");

                DataGrid(project);

                project.Close();
            }
            catch (Exception e)
            {
                MessageBox.Show(e.Message, "Exception", 
                    MessageBoxButtons.OK, MessageBoxIcon.Exclamation);
                if (project != null)
                    project.Close();
            }
            
        }
        public static void DataGrid(Project project)
        {
            string dataPath = 
            Environment.GetEnvironmentVariable("CI_DATA", EnvironmentVariableTarget.User);

            ConfigBase dc = project.GetConfiguration("GM data loader");
            DataLoaderConfig dcfg = (DataLoaderConfig)dc.Configuration;
            dcfg.InputFileName = dataPath + "iris.dat";
            Capsule dcaps = project.Create(dc);

            project.WaitAll();

            IOutput o = dcaps.Machine.GetOutput("Dataset");

            Intemi.Visualizers.DataGrid dg = new Intemi.Visualizers.DataGrid();

            ((IVisualizer)dg).UpdateView(o);
            dg.Show();
 
        }


    }
}