//---------------------------------------------------------------------------
#ifndef PCAH
#define PCAH

#if !defined(__MATH_H)
    #include <math.h>
#endif
#if !defined(__stdlib_h)
	#include <stdlib.h>
#endif
#include <string.h>
#if !defined (__FSTREAM_H)
    #include <fstream.h>
#endif
#if !defined (__TIME_H)
    #include <time.h>
#endif
//---------------------------------------------------------------------------
struct Zle
    {
    char* bl;
    Zle()
        {
        char x[]="Co poszo nie tak";
        bl=new char[25];
        strcpy(bl,x);
        }
    Zle(const char* x)
        {
        int ile=0;
        while (x[ile]!='\0') ile++;
        bl=new char[ile+5];
        strcpy(bl,x);
        }
    Zle(const Zle& x)
        {
        int ile=0;
        while (x.bl[ile]!='\0') ile++;
        bl=new char[ile+5];
        strcpy(bl,x.bl);
        }

    ~Zle()
        {
        delete[] bl;
        }

    };

template <class T>
class  PCA
    {
    public:
        PCA();
        ~PCA();
        PCA(const int,const int y=-1,float* z=0,int it=10,long double ep=0.00001,bool lo=false,bool ze=false);
        PCA(const int,const int y,float** z,int it,long double ep,bool lo=false,bool ze=false);
        PCA(const int,const int y,double** z,int it=10,long double ep=0.00001,bool lo=false,bool ze=false);
        PCA(const int,const int y,long double** z,int it,long double ep=0.00001,bool lo=false,bool ze=false);
        PCA(const PCA<T>&);
        PCA<T>& operator=(const PCA<T>&);
        PCA<T>  operator+(const PCA<T>&);
        operator long double**(void);
        T* operator[](const int i){return PcaData[i];};
        T** DoIt(int&,int&,const bool ,const bool f1=false);
        T** ToMulti(T**,const int,const int)const;
        T** ToMulti(const PCA<T>&,const int)const;
        bool klasy,Loging;
    private:
        int Iteracje;
        long double Eps;
        bool Zeros;
        int Prow,Pcol;
        T **PcaData;
        T** set(const int,const int y=-1,const bool z=true);
        void removPcaData(T**,const int);
        void LogToFile(const char* x=0,const int y=0) const;
        void FindMax(T* ,int*);
        void Multi(const PCA<T>&,const bool f1=false,long double Epp=0.00001);
        PCA<T> Cov(void) const;
        void ToHessenberg (void) const;
        int HessenbergQR (void);
        void Gauss(T *b=0,T *x=0,const bool f1=true);
        void EigenWektors(const bool f1=false,long double Epp=0.000001);
        void NormEigen(void);
        void Power(PCA<T>&,T*,const int,const int,const bool) const;
        void RedukcjaWielandta(PCA<T>&,const int,const int);
        void ClearX(T*,T*,const int) const;
        void ClearEps(void);

    };
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
template <class T>
T** PCA<T>::set(const int x,const int y, const bool z)
    {
    T** wynik=0;
    int xx,yy;
    if (x>0) xx=x;
    else xx=0;
    if (y>0) yy=y;
    else yy=xx;
    if (z==true)
      {
      Prow=xx;
      Pcol=yy;

      PcaData=new T*[Prow];
      for (int i=0;i<Prow;i++)
          PcaData[i]=new T[Pcol];
      }
    else
        {
        wynik=new T*[xx];
        for (int i=0;i<x;i++)
            wynik[i]=new T[yy];
        }
    return wynik;
    }
//---------------------------------------------------------------------------
template <class T>
void PCA<T>::removPcaData(T** x,const int y)
    {
    if (y>0 && x)
      {
      for (int i=0;i<y;i++)
          delete[] x[i];
      delete[] x;
      }
    //x=0;
    }
//---------------------------------------------------------------------------
template <class T>
void PCA<T>::LogToFile(const char* x,const int y) const
    {
    int col=Pcol;
    int row=Prow;
    char str[100];
    time_t timer;
    struct tm *tblock;
    timer = time(NULL);
    tblock = localtime(&timer);

    ofstream op("PcaLogData.txt",ios::app);
    op <<"\n";
    strcpy(str, asctime(tblock));
    op << str;
    if (x!=0)
        {
        op<<x;
        if (y==0) op <<"\nWszystko poszo dobrze";
        else op<<"\nByy problemy numer bdu "<<y;
        }
    op <<"\n";
    for (int i=0;i<row;i++)
        {
        for (int j=0;j<col;j++)
            {
            op<<PcaData[i][j];
            op<<"\t";
            }
        op<<"\n";
        }
    op.close();
    }
//---------------------------------------------------------------------------
template <class T>
PCA<T>::PCA()
    {
    Zeros=false;
    klasy=true;
    Iteracje=10;
    Eps=0.0001;
    Loging=false;
    PcaData=0;
    Prow=0;
    Pcol=0;
    }
//---------------------------------------------------------------------------
template <class T>
PCA<T>::PCA(const int x,const int y,float* b,int it,long double ep,bool lo,bool ze)
    {
    Zeros=ze;
    klasy=true;
    Loging=lo;
    set(x,y);
    Iteracje=it;
    Eps=ep;
    if (b!=0)
        {
        int k=0;
        for(int i=0;i<Prow;i++)
            for (int j=0;j<Pcol;j++)
                {
                PcaData[i][j]=(T)b[k];
                k++;
                }
        }
    }
//---------------------------------------------------------------------------
template <class T>
PCA<T>::PCA(const int x,const int y,float** b,int it,long double ep,bool lo,bool ze)
    {
    Zeros=ze;
    klasy=true;
    Loging=lo;
    Iteracje=it;
    Eps=ep;
    set(x,y);
    if (b!=0)
        {
        for(int i=0;i<Prow;i++)
            for (int j=0;j<Pcol;j++)
                PcaData[i][j]=(T)b[i][j];
        }
    }
//---------------------------------------------------------------------------
template <class T>
PCA<T>::PCA(const int x,const int y,double** b,int it,long double ep,bool lo,bool ze)
    {
    Zeros=ze;
    klasy=true;
    Loging=lo;
    Iteracje=it;
    Eps=ep;
    set(x,y);
    if (b!=0)
        {
        for(int i=0;i<Prow;i++)
            for (int j=0;j<Pcol;j++)
                PcaData[i][j]=(T)b[i][j];
        }
    }
//---------------------------------------------------------------------------
template <class T>
PCA<T>::PCA(const int x,const int y,long double** b,int it,long double ep,bool lo,bool ze)
    {
    Zeros=ze;
    klasy=true;
    Loging=lo;
    Iteracje=it;
    Eps=ep;
    set(x,y);
    if (b!=0)
        {
        for(int i=0;i<Prow;i++)
            for (int j=0;j<Pcol;j++)
                PcaData[i][j]=(T)b[i][j];
        }
    }
//---------------------------------------------------------------------------

template <class T>
PCA<T>::PCA(const PCA& x)
    {
    Zeros=x.Zeros;
    klasy=x.klasy;
    set(x.Prow,x.Pcol);
    Iteracje=x.Iteracje;
    Eps=x.Eps;
    Loging=x.Loging;
    if (x.PcaData!=0)
    for(int i=0;i<Prow;i++)
        for (int j=0;j<Pcol;j++)
            PcaData[i][j]=x.PcaData[i][j];
    }
//---------------------------------------------------------------------------
template <class T>
PCA<T>& PCA<T>::operator=(const PCA& xx)
    {
    if (PcaData!=0)
      {
      for (int i=0;i<Prow;i++)
          delete[] PcaData[i];
      delete[] PcaData;
      }

    set(xx.Prow,xx.Pcol);
    Zeros=xx.Zeros;
    klasy=xx.klasy;
    Iteracje=xx.Iteracje;
    Eps=xx.Eps;
    Loging=xx.Loging;

    if (xx.PcaData!=0)
    for(int i=0;i<Prow;i++)
        for (int j=0;j<Pcol;j++)
            PcaData[i][j]=xx.PcaData[i][j];
    return *this;
    }
//---------------------------------------------------------------------------
template <class T>
PCA<T> PCA<T>::operator+(const PCA& x)
    {
    if (x.Prow==this->Prow && x.Pcol==this->Pcol)
      {
      PCA wynik(*this);
      for (int i=0;i<wynik.Prow;i++)
          for (int j=0;j<wynik.Pcol;j++)
              {
              wynik.PcaData[i][j]=wynik.PcaData[i][j]+x.PcaData[i][j];
              }
      return wynik;
      }
    else
        return *this;
    }
//---------------------------------------------------------------------------
template <class T>
PCA<T>::operator long double**(void)
    {
    return PcaData;
    }
//---------------------------------------------------------------------------
/*
template <class T>
char* PCA<T>::showRow(const int x,char* dat)const
    {
    char str[300];
    char *ldat;
    if (dat!=0)
        {
        dat[0]='\0';
        ldat=dat;
        }
    else
        {
        ldat=new char[500];
        ldat[0]='\0';
        }
    int sig = 10;
    for (int j=0;j<Pcol;j++)
        {
        gcvt(PcaData[x][j], sig, str);
        strcat(ldat,str);
        strcat(ldat," ");
        }
    return ldat;
    }
*/
//---------------------------------------------------------------------------
template <class T>
PCA<T>::~PCA()
    {
    removPcaData(PcaData,Prow);
    PcaData=0;
    }
//---------------------------------------------------------------------------
template <class T>
PCA<T> PCA<T>::Cov(void) const
{
int col;
int row=Prow;
if (klasy==true)
    col=Pcol-1;
else
    col=Pcol;
if (col<=1)
    throw (Zle("Zy wymiar danych wejciowych. Kolumny<=1"));
long double *srednia=new long double[col];
long double lwynik;
PCA<T> wynik(col,col);

for (int i=0;i<col;i++)
    {
    long double suma=0;
    for(int j=0;j<row;j++)
        {
        suma+=PcaData[j][i];
        }
    if (Prow!=0)
        suma=suma/(long double)Prow;
    else
        throw Zle("Bd dzielenia. Zerowa liczba wierszy. Procedura Cov.");
    srednia[i]=suma;
    }
for (int j=0;j<col;j++)
    {
    for (int k=0;k<col;k++)
        {
        lwynik=0;
        for (int i=0;i<row;i++)
            {
            lwynik+=((long double)PcaData[i][j]-srednia[j])*((long double)PcaData[i][k]-srednia[k]);
            }
        lwynik=lwynik/(long double)(Prow-1);
        wynik.PcaData[k][j]=(T)lwynik;
        }
    }
delete[] srednia;
if (Loging==true)
    wynik.LogToFile("Macierz kowariancji");
wynik.Loging=Loging;
wynik.Eps=Eps;
wynik.Iteracje=Iteracje;
return wynik;
}
//---------------------------------------------------------------------------
template <class T>
void PCA<T>::ToHessenberg (void) const
{
int i,im,i1,j,k;
long double m,s;
for (i=0;i<Pcol-2;i++)
 {
   i1=i+1;
   im=i1;
   m=fabsl(PcaData[im][i]);
   for (j=i+1;j<Pcol;j++)
     {
       s=fabsl(PcaData[j][i]);
       if (s>m)
             {
              im=j;
              m=s;
              }
     }
   if (m>0)
         {
            if (im>i1)
                {
                     for (j=0;j<Pcol;j++)
                       {
                         m=PcaData[i1][j];
                         PcaData[i1][j]=PcaData[im][j];
                         PcaData[im][j]=m ;
                       }
                     for (j=0;j<Pcol;j++)
                       {
                         m=PcaData[j][i1];
                         PcaData[j][i1]=PcaData[j][im];
                         PcaData[j][im]=m;
                       }
                   }
            for (j=i+2;j<Pcol;j++)
              {
                if (PcaData[i1][i]!=0)
                    m=(long double)PcaData[j][i]/(long double)PcaData[i1][i];
                else
                    {
                    char x[200],z[20];
                    x[0]='\0';z[0]='\0';
                    strcpy(x,"Bd dzielenia. Element [");
                    itoa(i1,z,10);
                    strcat(x,z);
                    strcat(x,",");
                    itoa(i,z,10);
                    strcat(x,z);
                    strcat(x,"] jest zerem. Procedura ToHessenberg.");
                    throw Zle(x);
                    }
                for (k=0;k<Pcol;k++)
                  PcaData[j][k]=PcaData[j][k]-m*(long double)PcaData[i1][k];
                for (k=0;k<Pcol;k++)
                  PcaData[k][i1]=PcaData[k][i1]+m*(long double)PcaData[k][j];
              }
          }
 }
if (Loging==true)
    LogToFile("Sprowadzenie do postaci macierzy Hassenberga");
}
//---------------------------------------------------------------------------
/*
2, if during the decomposition the first column of a matrix
to be decomposed is the zero-column,
3, if the given accuracy eps is not achieved under it
iterations (when finding any of the eigenvalue),
0, otherwise.
eingevalues are stored on diagonal
*/
template <class T>
int PCA<T>::HessenbergQR (void)
{
int it=Iteracje;
long double eps=Eps;
int count,n1;
long double ap,hl,s,wk;
T **q=set(Pcol,Pcol,false),**r=set(Pcol,Pcol,false);
int st=0;
n1=Pcol-1;
do {
 count=0;
 do {
   count++;
   if (count>it)
           st=3;
     else {
            wk=PcaData[n1][n1];
            hl=wk;
            for (int i=0;i<=n1;i++)
              PcaData[i][i]=PcaData[i][i]-wk;
            s=0;
            for (int j=0;j<= n1 ;j++)
              {
                ap=PcaData[j][0];
                s=s+ap*ap;
              }
            s=sqrtl(s);
            if (s==0)
                {
                st=2;
                for (int i=0;i <= n1;i++)
                    PcaData[i][i]=PcaData[i][i]+wk;
                }
            else {
                     r[0][0]=s;
                     for (int j=0;j<=n1;j++)
                       q[j][0]=PcaData[j][0]/s;
                     for (int i=1;i<= n1;i++)
                       {
                         for (int k=0;k <= i-1 ;k++)
                           {
                             s=0;
                             for (int j=0;j <= n1;j++)
                               s=s+q[j][k]*PcaData[j][i];
                             r[k][i]=s ;
                           }
                         for (int j=0;j<= n1;j++)
                           {
                             s=0;
                             for (int k=0 ;k<= i-1;k++)
                               s=s+q[j][k]*r[k][i];
                             q[j][i]=PcaData[j][i]-s;
                           }
                         s=0;
                         for (int j=0 ;j<= n1;j++)
                           s=s+q[j][i]*q[j][i];
                         s=sqrtl(s);
                         if (s==0)
                            for (int j=0;j <= n1;j++)
                                  q[j][i]=0;
                         else
                            for (int j=0;j <= n1;j++)
                                  q[j][i]=q[j][i]/s;
                         for (int j=0;j <= i-1;j++)
                           r[i][j]=0;
                         r[i][i]=s;
                       }
                     for (int i=0;i <= n1;i++)
                       {
                         for (int j=0; j<= n1;j++)
                           {
                             s=0;
                             for (int k=0;k <= n1;k++)
                               s=s+r[i][k]*q[k][j];
                             PcaData[i][j]=s;
                           }
                         PcaData[i][i]=PcaData[i][i]+wk;
                       }
                   }
          }
   }
 while (fabsl(PcaData[n1][n1]-hl)>=eps &&
        PcaData[n1][n1-1]!=0 && st==0);
 if (st==0)
    n1--;
}
while( n1!=0 && st==0);
removPcaData(q,Pcol);
removPcaData(r,Pcol);
if (Loging==true)
    LogToFile("Procedura HassenbergQR",st);
return st;
}
//---------------------------------------------------------------------------
/*
0- wszystko ok
1-zly wymiar
3- utrata dokladnosci
*/
template <class T>
void PCA<T>::Gauss(T *b,T *x,const bool f1)
    {
    if (f1==true)
        {
        for (int i=0;i<Pcol;i++)
            {
            int index=i;
            long double max=fabsl(PcaData[i][i]);
            for (int j=i+1;j<Pcol;j++)
              {
              long double s=fabsl(PcaData[j][i]);
              if (max<s)
                  {
                  max=s;
                  index=j;
                  }
              }
            if (i!=index)
                {
                for (int j=i;j<Pcol;j++)
                    {
                    max=PcaData[i][j];
                    PcaData[i][j]=PcaData[index][j];
                    PcaData[index][j]=max;
                    }

                if (b!=0)
                    {
                    max=b[i];
                    b[i]=b[index];
                    b[index]=max;
                    }
                }
            for (int j=i+1;j<Pcol;j++)
                {
                if (PcaData[i][i]==0)
                    {
                    char x[200],z[20];
                    x[0]='\0';z[0]='\0';
                    strcpy(x,"Bd dzielenia. Element [");
                    itoa(i,z,10);
                    strcat(x,z);
                    strcat(x,",");
                    itoa(i,z,10);
                    strcat(x,z);
                    strcat(x,"] jest zerem. \nProcedura Gauss. Sprowadzanie do postaci trjktnej.");
                    throw Zle(x);
                    }
                else
                    max=PcaData[j][i]/PcaData[i][i];
                if (b!=0)
                    b[j]-=max*b[i];

                for (int k=i;k<Pcol;k++)
                    {
                    PcaData[j][k]-=max*PcaData[i][k];
                    if (Zeros==true && fabsl(PcaData[j][k])<Eps)
                        PcaData[j][k]=0;
                    }
                }
            }
        }
        if (x!=0 && b!=0)
            {
            if (PcaData[Pcol-1][Pcol-1]!=0)
                {
                x[Pcol-1]=b[Pcol-1]/PcaData[Pcol-1][Pcol-1];
                if (Zeros==true && fabsl(x[Pcol-1])<Eps)
                    x[Pcol-1]=0;
                }
            else
                {
                char x[200],z[20];
                x[0]='\0';z[0]='\0';
                strcpy(x,"Bd dzielenia. Element [");
                itoa(Pcol-1,z,10);
                strcat(x,z);
                strcat(x,",");
                itoa(Pcol-1,z,10);
                strcat(x,z);
                strcat(x,"] jest zerem. \nProcedura Gauss. Oblicznie pierwszego x-a.");
                throw Zle(x);
                }
            for (int i=Pcol-2;i>-1;i--)
                {
                long double s=b[i];
                for (int j=Pcol-1;j>i;j--)
                    s-=x[j]*PcaData[i][j];
                if (PcaData[i][i]!=0)
                    {
                    x[i]=s/PcaData[i][i];
                    if (Zeros==true && fabsl(x[i])<Eps)
                        x[i]=0;
                    }
                else
                    {
                    char x[200],z[20];
                    x[0]='\0';z[0]='\0';
                    strcpy(x,"Bd dzielenia. Element [");
                    itoa(i,z,10);
                    strcat(x,z);
                    strcat(x,",");
                    itoa(i,z,10);
                    strcat(x,z);
                    strcat(x,"] jest zerem. \nProcedura Gauss. Oblicznie x-w.");
                    throw Zle(x);
                    }
                }
            }
    if (Loging==true)
        {
        LogToFile("Procedura Gauss");
        Loging=false;
        }
    }
//---------------------------------------------------------------------------
template <class T>
void PCA<T>::EigenWektors(const bool f1,const long double Epp)
    {
    int st=0,index;
    bool ident=false;
    T** x=set(Pcol,Pcol,false);
    for (int i=0;i<Pcol;i++)
        {
        for (int j=Pcol-1;j>i;j--)
            {
            x[i][j]=0;
            }
        x[i][i]=1;
         for (int j=i-1;j>=0;j--)
            {
            long double suma=0;
            for (int k=j+1;k<=i;k++)
                 suma+=PcaData[j][k]*x[i][k];
            if ((PcaData[j][j]-PcaData[i][i])!=0)
                suma=suma/(PcaData[j][j]-PcaData[i][i]);
            else
                {
                suma=0;
                }

            if (f1==true && fabsl(suma)<Epp)
                suma=0;

            x[i][j]=suma*(-1.0);
            }

         if (ident==true)
            {
            for (int j=0;j<Pcol;j++)
                x[i][j]=x[index][j];
            ident=false;
            }

        }

    for (int i=0;i<Pcol;i++)
        for(int j=0;j<Pcol;j++)
            PcaData[i][j]=x[i][j];

    removPcaData(x,Pcol);
    if (Loging==true)
        LogToFile("Wektory wasne",st);
    }
//---------------------------------------------------------------------------
template <class T>
void  PCA<T>::FindMax(T* x,int*y)
    {
    for (int i=0;i<Pcol;i++)
        {
        int ind=i;
        T max=fabsl(x[i]);
        for (int j=i;j<Pcol;j++)
            {
            if (max<fabsl(x[j]))
                {
                max=fabsl(x[j]);
                ind=j;
                }
            }
        max=x[i];
        x[i]=x[ind];
        x[ind]=max;
        int k=y[i];
        y[i]=y[ind];
        y[ind]=k;
        }
    }
//---------------------------------------------------------------------------
template <class T>
void PCA<T>::Multi(const PCA<T>& a,const bool f1,long double Epp)
    {
    T* store=new T[Pcol];
    for (int i=0;i<Pcol;i++)
        {
        for (int k=0;k<Pcol;k++)
            {
            long double suma=0;
            for (int j=0;j<Pcol;j++)
                suma+=(long double)a.PcaData[k][j]*(long double)PcaData[i][j];
            store[k]=suma;
            }
        if (f1)
            {
            for (int k=0;k<Pcol;k++)
                if (fabsl(store[k])<Epp)
                    store[k]=0;
            }
        for (int k=0;k<Pcol;k++)
            PcaData[i][k]=store[k];
        }
    delete[] store;
    if (Loging==true)
        LogToFile("Procedura Multi");
    }
//---------------------------------------------------------------------------
template <class T>
T** PCA<T>::ToMulti(T** x,const int xProw,const int xPcol)const
{
if (xPcol!=Pcol-1) return 0;
T** wy=new T*[Prow];
for (int i=0;i<Prow;i++)
    wy[i]=new T[xProw+1];

T suma=0;
for (int k=0;k<Prow;k++)
    {
    for (int j=0;j<xProw;j++)
        {
        for (int i=0;i<xPcol;i++)
            suma+=PcaData[k][i]*x[j][i];
        wy[k][j]=suma;
        suma=0;
        }
    wy[k][xProw]=PcaData[k][Pcol-1];
    }
return wy;
}
//---------------------------------------------------------------------------
template <class T>
T** PCA<T>::ToMulti(const PCA<T>& x,const int y)const
{
T** wy=new T*[Prow];
for (int i=0;i<Prow;i++)
    wy[i]=new T[y+1];

int col;
if (klasy)
    col=Pcol-1;
else
    col=Pcol;
T suma=0;
for (int k=0;k<Prow;k++)
    {
    for (int j=0;j<y;j++)
        {
        for (int i=0;i<col;i++)
            suma+=PcaData[k][i]*x.PcaData[j][i];
        wy[k][j]=suma;
        suma=0;
        }
    if (klasy)
        {
        wy[k][y]=PcaData[k][Pcol-1];
        }
    }
return wy;
}
//---------------------------------------------------------------------------
template <class T>
void PCA<T>::ClearEps(void)
    {
    for (int i=0;i<Pcol;i++)
        for (int j=0;j<Pcol;j++)
            {
            if (fabsl(PcaData[i][j])<Eps)
                PcaData[i][j]=0;
            }
    }
//---------------------------------------------------------------------------
template <class T>
void PCA<T>::NormEigen(void)
    {
    for (int i=0;i<Pcol;i++)
        {
        long double max=fabsl(PcaData[i][0]);
        for (int j=0;j<Pcol;j++)
            {
            if (max<fabsl(PcaData[i][j]))
                max=fabsl(PcaData[i][j]);
            }
        for (int j=0;j<Pcol;j++)
            PcaData[i][j]=PcaData[i][j]/max;
        }
    if (Loging==true)
        LogToFile("Wektory wasne po normowaniu");

    }
//---------------------------------------------------------------------------

template <class T>
void PCA<T>::RedukcjaWielandta(PCA<T>& wyniki,const int ile,const int xPcol)
    {
    T max=fabsl(wyniki.PcaData[ile][0]);
    int index=0;

    for (int i=1;i<xPcol;i++)
         if (max<fabsl(wyniki.PcaData[ile][i]))
            {
            max=fabsl(wyniki.PcaData[ile][i]);
            index=i;
            }

    for(int i=0;i<xPcol;i++)
        {
        for (int j=0;j<xPcol;j++)
            {
            //max=(wyniki.PcaData[ile][j]*PcaData[index][i])/wyniki.PcaData[ile][index];
            max=wyniki.PcaData[ile][j]*PcaData[index][i];
            PcaData[j][i]-=max;
            }
        }

    if (index+1!=xPcol)
        {
        //Przesuwanie wierszy
        T* zapas=PcaData[index];
        for (int i=index;i<xPcol-1;i++)
            {
            PcaData[i]=PcaData[i+1];
            }
        PcaData[xPcol-1]=zapas;
        //Przestawianie kolumn
        for (int i=0;i<xPcol;i++)
            for (int j=index;j<xPcol-1;j++)
                {
                PcaData[i][j]=PcaData[i][j+1];
                }
        }

    if (Loging==true)
        LogToFile("Procedura RedukcjaWielandta");

    }
//---------------------------------------------------------------------------
template <class T>
void PCA<T>::ClearX(T* v,T* Eigen,const int num) const
    {
    if (num>0)
        {
        T* x=new T[Pcol];
        for (int i=0;i<num;i++)
            {
            for (int j=0;j<Pcol;j++)
                {
                x[j]=0;
                for (int k=0;k<Pcol;k++)
                    {
                    if (j!=k)
                        x[j]+=PcaData[j][k]*v[k];
                    else
                        x[j]+=(PcaData[j][k]-Eigen[i])*v[k];
                    }
                }
            for (int j=0;j<Pcol;j++)
                {
                v[j]=x[j];
                }
            }
        delete[] x;
        }
    }
//---------------------------------------------------------------------------
template <class T>
void PCA<T>::Power(PCA<T>& wyniki,T* Eigen,const int ile,const int num,const bool Eig) const
    {
    T* x=new T[Pcol];
    T* v=new T[Pcol];
    T lEigen;
    long double m,p;
    bool clear;

    if (num<=0 || ile!=Pcol || Eig==true)
        clear=false;
    else
        clear=true;

    for (int i=0;i<ile;i++)
        x[i]=1;

    for (int k=0;k<Iteracje;k++)
      {

      if (clear && (k/10)*10==k)
        {
        ClearX(x,Eigen,num);
        }

      for (int i=0;i<ile;i++)
          {
          long double suma=0;
          for (int j=0;j<ile;j++)
              {
              suma+=PcaData[i][j]*x[j];
              }
          v[i]=suma;
          }

      m=fabsl(v[0]);
      lEigen=v[0];
      for (int i=1;i<ile;i++)
          {
          if (m<fabsl(v[i]))
              {
              lEigen=v[i];
              m=fabsl(v[i]);
              }
          }
      if (m!=0)
          {
          for (int i=0;i<ile;i++)
              x[i]=v[i]/m;
          }
      else
          break;

      if (clear)
          {
          T diff0=fabsl(Eigen[num]-lEigen);

          if (diff0<Eps)
             break;
          }
      }


      for (int i=0;i<ile;i++)
         {
         wyniki.PcaData[num][i]=x[i];
         }

    if (Eig==true)
        {
        Eigen[num]=lEigen;
        }
    delete[] v;
    delete[] x;
    }
//---------------------------------------------------------------------------
template <class T>
T** PCA<T>::DoIt(int& QR,int& y,const bool f0,const bool f1)
    {
    int* lEigen=new int [Pcol];
    T* Eigen=new T[Pcol];
    T** wynik=0;

  PCA<T> store(*this);
  if (Loging==true)
    store.LogToFile("Orginalne dane");
  *this=Cov();
  //Pcol--;
  PCA<T> storeCov(*this);
  PCA<T> eW(Pcol,Pcol);

if (f0==true)
    {
      ToHessenberg();
      HessenbergQR();

      if (f1) ClearEps();

      for (int i=0;i<Pcol;i++)
          {
          Eigen[i]=PcaData[i][i];
          lEigen[i]=i;
          }
      FindMax(Eigen,lEigen);

      if (f1) ClearEps();
    }
else
    {
    if ((Iteracje/2)*2!=Iteracje)
        Iteracje++;
    for (int i=0;i<Pcol;i++)
        Eigen[i]=0;
    if (y<Pcol)
        {
        for (int i=0;i<y;i++)
                {
                if (i!=0)
                    RedukcjaWielandta(eW,(i-1),(Pcol-i+1));
                Power(eW,Eigen,Pcol-i,i,true);
                }
        }
    else
        {
        for (int i=0;i<Pcol-1;i++)
                {
                if (i!=0)
                   RedukcjaWielandta(eW,(i-1),(Pcol-i+1));
                Power(eW,Eigen,Pcol-i,i,true);
                }
        RedukcjaWielandta(eW,(Pcol-2),2);
        Eigen[Pcol-1]=PcaData[0][0];
        }
    }
  if (y>0)
      {
      for (int i=0;i<y;i++)
         storeCov.Power(eW,Eigen,Pcol,i,false);

      wynik=store.ToMulti(eW,y);

   (*this)=eW;

   if (store.Loging==true)
        {
        eW.LogToFile("Wektory wlasne macierzy kowariancji");

        ofstream op("PcaLogData.txt",ios::app);
        op <<"\nWartosci wlasne ";
        for (int i=0;i<Pcol;i++)
            op<<Eigen[i]<<"\t";
        op.close();
        }
    }
    delete[] Eigen;
    delete[] lEigen;

    return wynik;
    }
//---------------------------------------------------------------------------
#endif
