//---------------------------------------------------------------------------
#ifndef mAppH
#define mAppH
#if !defined (__mInOutH)
	#include "mInOut.h"
#endif
#if !defined (__mDaneH)
    #include "mDane.h"
#endif
#if !defined (__mStringH)
	#include "mString.h"
#endif
#if !defined (__mStructH)
    #include "mStruct.h"
#endif
#if !defined (__TIME_H)
    #include <time.h>
#endif

//---------------------------------------------------------------------------
class mApp
    {
    private:
        float* MakeRandomArr(const int);
        void numeruj_klasy(const int parametr=-1)const;
        void losuj_dane(const int,const int,const int,const bool opcja=1);
        void obliczaj_p_slow(const bool opcja=1);
        void obliczaj_p_fast(const bool opcja=1);
        void obliczaj_p_wektory(const bool opcja=1);
        void zamina_prosta1(const int);
        void zamina_prosta2(void);
        void zamina_prosta3(void);
        void zamina_prosta4(void);
        void zamina_prosta5(void);

        performBuff** buduj_macierz_wektorow(const bool opcja=1);
        performBuff zbadaj_ile_ram(const int)const;

        int ustal_jj(const mString&,performBuff** ,const int)const;
        int ustal_kk(const mString&,performBuff** ,const int,const int,const int)const;
        int ustalPozycje(const mString&,performBuff** ,const int,const int) const;
        int ustal_znacznik2(performBuff** ,const int,const int,const int,const int)const;

        void utworz_gcechy(const int,const int);
        void budujcechy0(void);
        void budujcechy1(performBuff**,const int,int&)const;
        void skalujDiskret(const int,const int);
        //******************************************
    protected:
        mDane* mData;
        performBuff** gcechy;
        bool *diskret;
        bool gstat;
        performBuff** buduj_macierz_wystapien(const int upp=1);
        void usun_gcechy(void);
        int ileKlas(const int) const;
    public:
        bool logowanie;
        mString *FName;
        int gmal1,gmal2;
        bool saveGcechy,itGcechy;
        unsigned int progress,progressMax;

        mApp(const char*);
        mApp(const mApp&);
        ~mApp();
        void DataLoad(const char*);
        void DataSave(const char*);
        void DeleteData(void);
        void ReadFromClip(const char*,const int,const bool ,const int);

        mDane* getData(void) const;
        const bool* getDiskret(void) const;
        const int getKlasa(void) const;
        mString* getFormat(void) const {return ((mData->getFormat()).getAll());};
        mOption getOptions(void)const{return *mData->preferences;};
        performBuff** getGcechy(void) const {return gcechy;};

        void podaj_wc(int &w ,int &c) const;

        void set_klasa(const int x);
        void setData(mDane* x){this->mData=x;};
        void setGcechy(performBuff** x){this->gcechy=x;};
        void setFormat(const mFormat& x){mData->setFormat(x);};
        void setOptions(const mOption& x);
        void setKlasa(const int);
        void setDiskret(const bool*);


        int ile_tab(void) const;
        void losuj(const int,const int,const int,const bool opcja=1);
        void obliczaj_p(const int, const bool opcja=1);
        void zamiana_prosta (const int,const int);

        void zamienaj_symbole(const mString&,const mString&,const int,const int);
        void zamienaj_symbole(char*,char*,const int,const int);
        void standaryzacja(const bool,const int);
        void DeleteCol(const int,const int,const bool);
        void przestaw_kolumny(const int x,const int y);

        void numeruj_kolumny(const int, const bool opcja=1);
  //******************************************

    };
//---------------------------------------------------------------------------
class statystyka :protected mApp
    {
    private:
      void analiza0(void);
      void analiza2(const int);
    public:
      int pola;
      int klasy;
      float **info;
      statystyka(const mApp&);
      int** analizaCol(const int);
      ~statystyka(void);
    };
//---------------------------------------------------------------------------
#endif
