//---------------------------------------------------------------------------
//#include <vcl.h>
#pragma hdrstop

#if !defined (__mTasksH)
    #include "mTasks.h"
#endif
//---------------------------------------------------------------------------
#pragma package(smart_init)
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
__fastcall pUsuwanie::pUsuwanie(bool CreateSuspended,TDokument *x,const TRect& y,const bool z)
    : TThread(CreateSuspended)
{
    int Urow,Ucol;
    status=z;
    Child=x;
    FreeOnTerminate=true;
    Column0=y.Bottom;
    Row0=y.Top;
    Column1=y.Right;
    Row1=y.Left;
    mDane *pt=Child->mEngine->getData();
    Urow=pt->preferences->row;
    Ucol=pt->preferences->col;
    if (Column0<=0 || Column1<=0)
        {
        Column0=1;
        Column1=Ucol;
        }
    if (Row0<=0 || Row1<=0)
        {
        Row0=1;
        Row1=Urow;
        }
}
//---------------------------------------------------------------------------
void __fastcall pUsuwanie::Execute()
    {
    if (Child && Child->StringGrid1)
      {
      this->setUp();
      if (Usuwanie)
          {
          Child->Perform(ACTIVEDOC,0,0);
          Child->showPanel=true;
          mZamiana->Perform(STATUSSHOW,2,0);
          Usuwanie->ShowModal();
          delete Usuwanie;
          Usuwanie=0;
          Child->Perform(ACTIVEDOC,1,0);
          }
      }
    }
//---------------------------------------------------------------------------
void __fastcall pUsuwanie::UsuwanieClose(TObject *Sender, TCloseAction &Action)
    {
    if (Action==caNone)
        Usuwanie->Close();
    else
      {
      delete OK;
      delete Edit1;
      delete Edit2;
      delete Label1;
      delete Label2;
      delete Label3;
      delete UsunWiersz;
      delete UsunKolumne;
      delete GroupBox1;
      delete Timer1;
      if (Child && Child->StringGrid1)
          Child->showPanel=false;
      }
    }
//---------------------------------------------------------------------------
void __fastcall pUsuwanie::UsuwanieKeyPress(TObject *Sender, char &Key)
  {
  if (Key==27)
    {
    TCloseAction xAction=caNone;
    UsuwanieClose(Sender,xAction);
    }
  }
//---------------------------------------------------------------------------
void __fastcall pUsuwanie::setUp(void)
    {
    res=true;
    randomize();
    Usuwanie=new TForm(Application);
    Usuwanie->Left=339+random (200);
    Usuwanie->Top=147+random (200);
    Usuwanie->BorderStyle=bsSingle;
    AnsiString caption;
    if (status)
        caption="Usuwanie ";
    else
        caption="Kopiowanie do schowka ";
    caption=caption+(const char*)(*Child->mEngine->FName);
    Usuwanie->Caption=caption;
    Usuwanie->ClientHeight=155;
    Usuwanie->ClientWidth=196;
    TBorderIcons ikony;
    ikony=ikony + (ikony << biSystemMenu);
    Usuwanie->BorderIcons = ikony;
    Usuwanie->Color=clBtnFace;
    Usuwanie->Font->Charset=DEFAULT_CHARSET;
    Usuwanie->Font->Color=clWindowText;
    Usuwanie->Font->Height=-11;
    Usuwanie->Font->Name="Default";
    Usuwanie->Font->Style=Usuwanie->Font->Style << fsBold;
    Usuwanie->FormStyle=fsStayOnTop;
    Usuwanie->OldCreateOrder=false;
    Usuwanie->OnClose=UsuwanieClose;
    //Usuwanie->Position=poDesktopCenter;
    Usuwanie->Visible=false;
    Usuwanie->PixelsPerInch=96;

    GroupBox1=new TGroupBox(Usuwanie);
    GroupBox1->Left = 6;
    GroupBox1->Top = 1;
    GroupBox1->Width = 184;
    GroupBox1->Height = 148;
    GroupBox1->TabOrder = 0;
    GroupBox1->Parent=Usuwanie;

    Label1=new TLabel(GroupBox1);
    Label1->Left=8;
    Label1->Top=60;
    Label1->Width=144;
    Label1->Height=13;
    if (status)
        Label1->Caption="Numery usuwanych kolumn";
    else
        Label1->Caption="Numery kopiowanych kolumn";
    Label1->Parent = GroupBox1;

    UsunKolumne=new TRadioButton(GroupBox1);
    UsunKolumne->Left=8;
    UsunKolumne->Top=14;
    UsunKolumne->Width=113;
    UsunKolumne->Height=17;
    if (status)
        UsunKolumne->Caption="Usuwaj kolumny";
    else
        UsunKolumne->Caption="Kopiuj kolumny";
    UsunKolumne->Checked=true;
    UsunKolumne->Font->Charset=DEFAULT_CHARSET;
    UsunKolumne->Font->Color=clWindowText;
    UsunKolumne->Font->Height=-11;
    UsunKolumne->Font->Name="Default";
    UsunKolumne->Font->Style=UsunKolumne->Font->Style<<fsBold;
    UsunKolumne->ParentFont=true;
    UsunKolumne->TabOrder=0;
    UsunKolumne->TabStop=true;
    UsunKolumne->OnClick=UsunKolumneClick;
    UsunKolumne->OnKeyPress=UsuwanieKeyPress;
    UsunKolumne->Parent = GroupBox1;

    UsunWiersz=new TRadioButton(GroupBox1);
    UsunWiersz->Left=8;
    UsunWiersz->Top=40;
    UsunWiersz->Width=113;
    UsunWiersz->Height=17;
    if (status)
        UsunWiersz->Caption="Usuwaj wiersze";
    else
        UsunWiersz->Caption="Kopiuj wiersze";
    UsunWiersz->Font->Charset=DEFAULT_CHARSET;
    UsunWiersz->Font->Color=clWindowText;
    UsunWiersz->Font->Height=-11;
    UsunWiersz->Font->Name="Default";
    UsunWiersz->Font->Style=UsunWiersz->Font->Style<<fsBold;
    UsunWiersz->ParentFont=true;
    UsunWiersz->TabOrder=1;
    UsunWiersz->OnClick=UsunWierszClick;
    UsunWiersz->OnKeyPress=UsuwanieKeyPress;
    UsunWiersz->Parent = GroupBox1;

    OK=new TButton(GroupBox1);
    OK->Left=7;
    OK->Top=116;
    OK->Width=169;
    OK->Height=25;
    OK->Caption="OK";
    OK->TabOrder=2;
    OK->OnClick=OKClick;
    OK->Parent = GroupBox1;

    Label2=new TLabel(GroupBox1);
    Label2->Left=6;
    Label2->Top=88;
    Label2->Width=15;
    Label2->Height=13;
    Label2->Caption="od";
    Label2->Parent = GroupBox1;
    Label3=new TLabel(GroupBox1);
    Label3->Left=92;
    Label3->Top=88;
    Label3->Width=15;
    Label3->Height=13;
    Label3->Caption="do";
    Label3->Parent = GroupBox1;

    Edit1=new TEdit(GroupBox1);
    Edit1->Left=25;
    Edit1->Top=84;
    Edit1->Width=65;
    Edit1->Height=21;
    Edit1->BiDiMode=bdRightToLeft;
    Edit1->ParentBiDiMode=false;
    Edit1->TabOrder=3;
    Edit1->Enabled=true;
    Edit1->OnKeyPress=UsuwanieKeyPress;
    Edit1->Parent = GroupBox1;

    Edit2=new TEdit(GroupBox1);
    Edit2->Left = 111;
    Edit2->Top = 84;
    Edit2->Width = 65;
    Edit2->Height = 21;
    Edit2->TabOrder = 4;
    Edit2->Enabled=true;
    Edit2->OnKeyPress=UsuwanieKeyPress;
    Edit2->Parent = GroupBox1;

    if (Column0>0 && Column1>0)
        {
        Edit1->Text=Column0;
        Edit2->Text = Column1;
        }
    else
        {
        Edit2->Text="?";
        Edit1->Text="?";
        }
    Timer1=new TTimer(Usuwanie);
    if (Timer1)
        {
        Timer1->Interval=500;
        Timer1->OnTimer=Timer1tyk;
        Timer1->Enabled=true;
        }
    }
//---------------------------------------------------------------------------
void __fastcall pUsuwanie::Timer1tyk(TObject *Sender)
    {
    if (Child==NULL || Child->StringGrid1==NULL) Usuwanie->Close();
    else if (!Usuwanie->Active)
       {
       if (res==true)
        {
        Column0=Child->Column0;
        Column1=Child->Column1;
        Row0=Child->Row0;
        Row1=Child->Row1;
        Edit1->Text=Column0;
        Edit2->Text =Column1;
        }
       else
        {
        Column0=Child->Column0;
        Column1=Child->Column1;
        Row0=Child->Row0;
        Row1=Child->Row1;
        Edit1->Text=Row0;
        Edit2->Text =Row1;
        }
       }
    }
//---------------------------------------------------------------------------
void __fastcall pUsuwanie::UsunKolumneClick(TObject *Sender)
{
if (status)
    Label1->Caption="Numery usuwanych kolumn";
else
    Label1->Caption="Numery kopiowanych kolumn";
if (Column0!=0 && Column1!=0)
    {
    Edit1->Text=Column0;
    Edit2->Text = Column1;
    }
res=true;
}
//---------------------------------------------------------------------------
void __fastcall pUsuwanie::UsunWierszClick(TObject *Sender)
{
if (status)
    Label1->Caption="Numery usuwanych wierszy";
else
    Label1->Caption="Numery kopiowanych wierszy";
if (Row0!=0 && Row1!=0)
  {
  Edit1->Text=Row0;
  Edit2->Text =Row1;
  }
res=false;
}
//---------------------------------------------------------------------------
void __fastcall pUsuwanie::OKClick(TObject *Sender)
{
if (Child==NULL || Child->StringGrid1==NULL) Usuwanie->Close();
else if (Edit1->Text!=0 && Edit1->Text!="?" &&
    Edit2->Text!=0 && Edit2->Text!="?")
    {
    if (status)
        {
        try
            {
            AnsiString store=Edit1->Text;
            int cipher1=store.ToInt();
            store=Edit2->Text;
            int cipher2=store.ToInt();
            if (cipher1<=0) cipher1=1;
            if (cipher2<=0) cipher2=1;
            if (Child && Child->StringGrid1)
                {
                Child->mEngine->DeleteCol(cipher1,cipher2,res);
                Usuwanie->Close();
                Child->ShowGrid1();
                }
            else Usuwanie->Close();
            }
        catch (char* x)
            {
            Edit1->Text="1";
            Edit2->Text="2";
            MessageBeep(-1);
            Application->MessageBox(x,"Bd", MB_OK);
            }
        catch(...)
            {
            Edit1->Text="1";
            Edit2->Text="2";
            MessageBeep(-1);
            Application->MessageBox("To nie jest cyfra!!!","Bd", MB_OK);
            }

        }
    else
        {
        Synchronize(mZamiana->lSchowek->SchowekClear);
        mDane *ptr=Child->mEngine->getData();
        mString wyr;
        if (res==true)
            {
            //kolumny
            int x1,x2;
            if (Column0<Column1)
                {
                x1=Column0-1;
                x2=Column1;
                }
            else
                {
                x1=Column1-1;
                x2=Column0;
                }
            wyr=ptr->getLine(x1,false,x2-x1);
            mZamiana->lSchowek->SchowekAdd((const char*)wyr);
            }
        else
            {
            //wiersze
            int x1,x2;
            if (Row0<Row1)
                {
                x1=Row0-1;
                x2=Row1;
                }
            else
                {
                x1=Row1-1;
                x2=Row0;
                }
            for (int i=x1;i<x2;i++)
                {
                wyr=ptr->getLine(i);
                mZamiana->lSchowek->SchowekAdd((const char*)wyr);
                }

            }
        mZamiana->lSchowek->SchowekCopy();
        Usuwanie->Close();
        }
    }
else
    {
    Edit1->Text="1";
    Edit2->Text="2";
    Application->MessageBox("W okienko edycyjne musisz wpisa cyfr","Uwaga", MB_OK);
    }
}
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
__fastcall pShow::pShow(bool CreateSuspended,TDokument* x)
    : TThread(CreateSuspended)
{
Child=x;
if (Child)
    status=true;
else
    status=false;
FreeOnTerminate=true;
}
//---------------------------------------------------------------------------
void __fastcall pShow::Execute()
    {
    if (status)
        {
        while(Child->working==true) Sleep(500);

        Child->Perform(ACTIVEDOC,0,0);
        Synchronize(UpdateLista);
        Child->Perform(ACTIVEDOC,1,0);
        }
    }
//---------------------------------------------------------------------------
void __fastcall pShow::UpdateLista()
    {

    int wiersz,kol;
    mDane *lwskData=Child->mEngine->getData();
    if (lwskData)
        {
        int klasa=lwskData->preferences->klas+1;
        wiersz=lwskData->preferences->row;
        kol=lwskData->preferences->col;
        if (wiersz==0) wiersz=10;
        if (kol==0) kol=10;
        if (!Child->StringGrid1) return;
        Child->StringGrid1->ColCount=kol+1;
        Child->StringGrid1->RowCount=wiersz+1;
        Child->StringGrid1->DefaultColWidth=5*Child->mEngine->ile_tab();
        Child->StringGrid1->ColWidths[0]=32;
        if (kol!=1 && klasa!=-2)
            Child->StringGrid1->ColWidths[klasa]=32;
        for(int i=0;i<kol;i++)
          {
          if (!Child->StringGrid1) return;
          Child->StringGrid1->Cells[i+1][0] =i+1;
          }

        mZamiana->Perform(STATUSSHOW,0,0);

        for(int j=0;j<wiersz;j++)
            {
            if (!Child->StringGrid1) return;
            Child->StringGrid1->Cells[0][j+1] =j+1;
            Child->Perform(ADDPROGRESS,0,0);
            for(int i=0;i<kol;i++)
                {
                if (!Child->StringGrid1) return;
                Child->StringGrid1->Cells[i+1][j+1] =(const char*)lwskData->get(j,i);
                }
            }

        //Status wykonania zadania
        mZamiana->Perform(STATUSSHOW,1,0);

        //Postp na pasku "progress"
        Child->Perform(ADDPROGRESS,1,0);
        }
    }
//---------------------------------------------------------------------------
__fastcall pTransform1::pTransform1(bool CreateSuspended,TDokument *x,const int y,const int z)
    : TThread(CreateSuspended)
{
    Child=x;
    FreeOnTerminate=true;
    op1=y;
    op2=z;
}
//---------------------------------------------------------------------------
void __fastcall pTransform1::Execute()
    {
    if (Child->StringGrid1)
        {
        mZamiana->Perform(STATUSSHOW,4,0);
        Child->Perform(ACTIVEDOC,0,0);
        pProgress *wSP = new pProgress(true,Child);
        wSP->Priority =this->Priority;
        wSP->Resume();
        try
            {
            Child->mEngine->zamiana_prosta(op1,op2);
            }
        catch (char* xx)
            {
            wSP->Terminate();
            MessageBeep(-1);
            Application->MessageBox(xx,"Bd", MB_OK);
            }
        wSP->Terminate();
        Child->Perform(ACTIVEDOC,1,0);
        Child->ShowGrid1();
        }
    }
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
__fastcall pTransform1A ::pTransform1A (bool CreateSuspended,TDokument *x1,TDokument *x2,const int y,const int z)
    : TThread(CreateSuspended)
{
    Child1=x1;
    Child2=x2;
    FreeOnTerminate=true;
    op1=y;
    op2=z;
}
//---------------------------------------------------------------------------
void __fastcall pTransform1A ::Execute()
    {
    if (Child1->StringGrid1)
        {
        Child1->Perform(ACTIVEDOC,0,0);
        pProgress *wSP1 = new pProgress(true,Child1);
        wSP1->Priority =this->Priority;
        wSP1->Resume();
        try
            {
            Child1->mEngine->saveGcechy=true;
            Child1->mEngine->zamiana_prosta(op1,op2);
            Child1->mEngine->saveGcechy=false;
            }
        catch (char* xx)
            {
            wSP1->Terminate();
            MessageBeep(-1);
            Application->MessageBox(xx,"Bd", MB_OK);
            }
        wSP1->Terminate();
        Child1->Perform(ACTIVEDOC,1,0);
        Child1->ShowGrid1();
        }
    if (Child2->StringGrid1)
        {
        Child2->Perform(ACTIVEDOC,0,0);
        pProgress *wSP2 = new pProgress(true,Child2);
        wSP2->Priority =this->Priority;
        wSP2->Resume();
        try
            {
            Child2->mEngine->gmal1=Child1->mEngine->gmal1;
            Child2->mEngine->gmal2=Child1->mEngine->gmal2;
            Child2->mEngine->setGcechy(Child1->mEngine->getGcechy());
            Child2->mEngine->itGcechy=false;
            Child2->mEngine->zamiana_prosta(op1,op2);
            Child2->mEngine->itGcechy=true;
            Child1->mEngine->setGcechy(0);
            }
        catch (char* xx)
            {
            wSP2->Terminate();
            MessageBeep(-1);
            Application->MessageBox(xx,"Bd", MB_OK);
            }

        wSP2->Terminate();
        Child2->Perform(ACTIVEDOC,1,0);
        Child2->ShowGrid1();
        }
    }
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
__fastcall pTransform2::pTransform2(bool CreateSuspended,TDokument *x,const int y,const bool z)
    : TThread(CreateSuspended)
{
    Child=x;
    FreeOnTerminate=true;
    op1=y;
    op2=z;
}
//---------------------------------------------------------------------------
void __fastcall pTransform2::Execute()
    {
    if (Child->StringGrid1)
        {
        Child->Perform(ACTIVEDOC,0,0);
        pProgress *wSP = new pProgress(true,Child);
        wSP->Priority =this->Priority;
        wSP->Resume();
        try
            {
            Child->mEngine->obliczaj_p(op1,op2);
            }
        catch (char* xx)
            {
            wSP->Terminate();
            MessageBeep(-1);
            Application->MessageBox(xx,"Bd", MB_OK);
            }
        wSP->Terminate();
        Child->Perform(ACTIVEDOC,1,0);
        Child->ShowGrid1();
        }
    }
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
__fastcall pTransform2A ::pTransform2A (bool CreateSuspended,TDokument *x1,TDokument *x2,const int y,const bool z)
    : TThread(CreateSuspended)
{
    Child1=x1;
    Child2=x2;
    FreeOnTerminate=true;
    op1=y;
    op2=z;
}
//---------------------------------------------------------------------------
void __fastcall pTransform2A ::Execute()
    {
    if (Child1->StringGrid1)
        {
        Child1->Perform(ACTIVEDOC,0,0);
        Child1->mEngine->saveGcechy=true;
        pProgress *wSP1 = new pProgress(true,Child1);
        wSP1->Priority =this->Priority;
        wSP1->Resume();
        try
            {
            Child1->mEngine->obliczaj_p(op1,op2);
            }
        catch (char* xx)
            {
            wSP1->Terminate();
            MessageBeep(-1);
            Application->MessageBox(xx,"Bd", MB_OK);
            }
        wSP1->Terminate();
        Child1->mEngine->saveGcechy=false;
        Child1->Perform(ACTIVEDOC,1,0);
        Child1->ShowGrid1();
        }
    if (Child2->StringGrid1)
        {
        Child2->Perform(ACTIVEDOC,0,0);
        Child2->mEngine->gmal1=Child1->mEngine->gmal1;
        Child2->mEngine->gmal2=Child1->mEngine->gmal2;
        Child2->mEngine->setGcechy(Child1->mEngine->getGcechy());
        Child2->mEngine->itGcechy=false;
        pProgress *wSP2 = new pProgress(true,Child2);
        wSP2->Priority =this->Priority;
        wSP2->Resume();
        try
            {
            Child2->mEngine->obliczaj_p(op1,op2);
            }
        catch (char* xx)
            {
            wSP2->Terminate();
            MessageBeep(-1);
            Application->MessageBox(xx,"Bd", MB_OK);
            }
        wSP2->Terminate();
        Child2->mEngine->itGcechy=true;
        Child1->mEngine->setGcechy(0);
        Child2->Perform(ACTIVEDOC,1,0);
        Child2->ShowGrid1();
        }
    }
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
__fastcall pEdycja::pEdycja(bool CreateSuspended,TDokument *x1,int x,int y)
    : TThread(CreateSuspended)
{
FreeOnTerminate=true;
if (x1)
    {
    Child=x1;
    row=x-1;
    col=y-1;
    mDane *zap=x1->mEngine->getData();
    edzap=zap->get_char(row,col);
    }
else
    {
    Child=0;
    col=0;
    row=0;
    edzap="?";
    }
}
//---------------------------------------------------------------------------
void __fastcall pEdycja::Execute()
    {
    if (Child && Child->StringGrid1)
      {
      this->utworz();
      if (ed)
          {
          ed->ShowModal();
          delete ed;
          }
      }
    }
//---------------------------------------------------------------------------
void __fastcall pEdycja::edClose(TObject *Sender, TCloseAction &Action)
{
Timer1->Enabled=false;
this->skasuj();
}
//---------------------------------------------------------------------------
void __fastcall pEdycja::ok1Click(TObject *Sender)
    {
    ed->Visible=false;
    edzap=Edit1->Text;
    if (edzap=="\0")
        edzap="Brak danej";
    if (Child && Child->StringGrid1)
        {
        mDane *zap=Child->mEngine->getData();
        zap->set(edzap.c_str(),row,col);
        Synchronize(UpdateLista);
        }
    ed->Close();
    }
//---------------------------------------------------------------------------
void __fastcall pEdycja::UpdateLista()
    {
    Child->StringGrid1->Cells[col+1][row+1] = edzap;
    }
//---------------------------------------------------------------------------
void __fastcall pEdycja::Timer1tyk(TObject *Sender)
    {
    if (Child==NULL || Child->StringGrid1==NULL) ed->Close();
    else if (!ed->Active)
       {
       licznik++;
       mDane *zap=Child->mEngine->getData();
       edzap=zap->get_char(row,col);
       Edit1->Text =edzap;
       if (licznik==6)
           ed->Close();
       }
    }
//---------------------------------------------------------------------------
void __fastcall pEdycja::Edit1KeyPress(TObject *Sender, char &Key)
{
  if (Key==13)
    ok1Click(Sender);
  else if (Key==27)
    {
    ok1Click(Sender);
    }
}
//---------------------------------------------------------------------------
void __fastcall pEdycja::skasuj(void)
    {
    delete ok;
    delete Edit1;
    delete GroupBox1;
    delete Timer1;
    }
//---------------------------------------------------------------------------
void __fastcall pEdycja::utworz(void)
    {
    ed=0;
    licznik=0;
    AnsiString cap="Edycja ";
    cap=cap+(const char*)(*Child->mEngine->FName);
    randomize();
    ed=new TForm(Application);
    if (ed!=0)
        {
        TBorderIcons ikony;
        ikony=ikony + (ikony << biSystemMenu);
        ed->Left = 259+random (200);
        ed->Top = 125+random (200);
        ed->ClientWidth = 192;
        ed->ClientHeight = 100;
        ed->Caption = cap;
        ed->BorderIcons = ikony;
        ed->Color = clBtnFace;
        ed->Font->Charset = DEFAULT_CHARSET;
        ed->Font->Color = clWindowText;
        ed->Font->Height = -11;
        ed->Font->Name = "Default";
        ed->Font->Style = ed->Font->Style << fsBold;
        ed->BorderStyle=bsSingle;
        ed->FormStyle=fsStayOnTop;
        ed->OldCreateOrder = true;
        ed->PixelsPerInch = 96;
        ed->OnClose=edClose;
    GroupBox1=new TGroupBox(ed);
    GroupBox1->Left = 8;
    GroupBox1->Top = 4;
    GroupBox1->Width = 176;
    GroupBox1->Height = 87;
    cap="Edycja komrki ";
    cap=cap+(row+1);
    cap=cap+"*";
    cap=cap+(col+1);
    GroupBox1->Caption = cap;
    GroupBox1->TabOrder = 0;
    GroupBox1->Parent=ed;

        Edit1=0;
        Edit1=new TEdit(GroupBox1);
        if (Edit1!=0)
            {
            Edit1->Left = 16;
            Edit1->Top = 20;
            Edit1->Width = 145;
            Edit1->Height = 25;
            Edit1->TabOrder = 0;

            Edit1->Text =edzap;
            Edit1->Parent=GroupBox1;
            Edit1->OnKeyPress=Edit1KeyPress;
            }
          ok=0;
          ok=new  TButton(GroupBox1);
          if(ok!=0)
            {
            ok->Left = 16;
            ok->Top = 51;
            ok->Width = 145;
            ok->Height = 25;
            ok->Caption = "OK";
            ok->TabOrder = 1;
            ok->OnClick=ok1Click;
            ok->Parent=GroupBox1;
            }
        Timer1=new TTimer(ed);
        if (Timer1)
            {
            Timer1->Interval=10000;
            Timer1->OnTimer=Timer1tyk;
            Timer1->Enabled=true;
            }
        }
    }
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
__fastcall pDCtask::pDCtask(bool CreateSuspended,TDokument* x)
    : TThread(CreateSuspended)
{
Child=x;
FreeOnTerminate=true;
}
//---------------------------------------------------------------------------
void __fastcall pDCtask::Execute()
{
this->utworz();
if (dyskr && Child->StringGrid1)
    {
    Child->Perform(ACTIVEDOC,0,0);
    dyskr->ShowModal();
    delete dyskr;
    Child->Perform(ACTIVEDOC,1,0);
    }
}
//---------------------------------------------------------------------------
void __fastcall pDCtask::dyskrClose(TObject *Sender, TCloseAction &Action)
{

if (Action==caNone)
    dyskr->Close();
else
    this->skasuj();
}
//---------------------------------------------------------------------------
void __fastcall pDCtask::DCtaskKeyPress(TObject *Sender, char &Key)
  {
  if (Key==13)
    okClick(Sender);
  else if (Key==27)
    {
    TCloseAction xAction=caNone;
    dyskrClose(Sender,xAction);
    }
  }
//---------------------------------------------------------------------------

void __fastcall pDCtask::skasuj()
{
if (dyskr!=0)
  {
  if (c1!=0)
    {
    for (int i=0;i<ile_c1;i++)
        if (i!=klas-1)
            delete c1[i];
    delete[] c1;
    }
    delete ok;
    delete wlacz;
    delete wylacz;
    delete GroupBox1;
  }
}
//---------------------------------------------------------------------------
void __fastcall pDCtask::utworz()
{
  int w,c;
  ok=0;
  wlacz=wylacz=0;
  c1=0;
  if (Child->mEngine!=0)
    {
    Child->mEngine->podaj_wc(w,c);
    klas=Child->mEngine->getKlasa();
    }
  else
    {
    klas=0;
    w=10;
    c=10;
    }
  ile_c1=c;
  dyskr=new TForm(Application);
  if (dyskr!=0)
    {
    dyskr->Left = 400;
    dyskr->Top = 150;
    dyskr->Width = 540;
    dyskr->Height = 100+20*(c/10+1);
    dyskr->Caption = "Zaznaczanie atrybutw o charakterze cigym";
    dyskr->Color = clBtnFace;
    dyskr->Font->Charset = DEFAULT_CHARSET;
    dyskr->Font->Color = clWindowText;
    dyskr->Font->Height = -11;
    dyskr->Font->Style=dyskr->Font->Style << fsBold;
    dyskr->Font->Name = "Default";
    dyskr->BorderStyle=bsSizeable;
    dyskr->FormStyle=fsStayOnTop;
    dyskr->OldCreateOrder = true;
    dyskr->PixelsPerInch = 96;
    dyskr->OnClose=dyskrClose;
    //*******************************
    GroupBox1=new TGroupBox(dyskr);
    GroupBox1->Align = alClient;
    GroupBox1->Parent=dyskr;
    //*******************************
    c1=new TCheckBox*[ile_c1];
    if (dyskr!=0 && c1!=0)
      {
      char *name="c";
      int j=30;
      int k=-1;
      for (int i=0;i<ile_c1;i++)
          if (i!=klas-1)
            {
            if (i!=0 && (i/10)*10==i)
              {
              j=j+30;
              k=-1;
              }
            k++;
            c1[i]=new TCheckBox(dyskr);
            c1[i]->Left = 50*k+10;
            c1[i]->Top = 10+j;
            c1[i]->Width = 60;
            c1[i]->Height = 17;
            c1[i]->Caption = IntToStr(i+1);
            //c1[i]->TabOrder =(unsigned int)i;
            c1[i]->TabStop=false;
            c1[i]->Visible=true;
            c1[i]->Name =name + IntToStr(i+1);
            c1[i]->OnKeyPress=DCtaskKeyPress;
            c1[i]->Parent = GroupBox1;
            }
      //*******************************
      ok=new TButton(dyskr);
      if (ok!=0)
        {
        ok->Left=200;
        ok->Top=13;
        ok->Width=120;
        ok->Height=20;
        ok->Caption="Ok";
        ok->Name="okp";
        ok->Parent=GroupBox1;
        ok->OnClick=okClick;
        ok->OnKeyPress=DCtaskKeyPress;
        ok->Visible=true;
        }
      wlacz=new TButton(dyskr);
      if (wlacz!=0)
        {
        wlacz->Left=50;
        wlacz->Top=13;
        wlacz->Width=120;
        wlacz->Height=20;
        wlacz->Caption="Wcz wszystkie";
        wlacz->Name="wlacz";
        wlacz->Parent=GroupBox1;
        wlacz->OnClick=wlaczClick;
        wlacz->Visible=true;
        }
      wylacz=new TButton(dyskr);
      if (wylacz!=0)
        {
        wylacz->Left=350;
        wylacz->Top=13;
        wylacz->Width=120;
        wylacz->Height=20;
        wylacz->Caption="Wycz wszystkie";
        wylacz->Name="wylacz";
        wylacz->Parent=GroupBox1;
        wylacz->OnClick=wylaczClick;
        wylacz->Visible=true;
        }
      }
      //*******************************
      const bool *ptr=Child->mEngine->getDiskret();
      if (Child->mEngine!=0 && ptr!=0)
          {
          for (int i=0;i<ile_c1;i++)
              {
              if (i!=klas-1 && ptr[i]==1)
                  c1[i]->State=cbChecked;
              }
          }
      //*******************************
      }
}
//---------------------------------------------------------------------------
void __fastcall pDCtask::okClick(TObject *Sender)
    {
    dyskr->Visible=false;
    //*******************************
    if (Child->mEngine!=0)
        {
        bool *wsk=new bool[ile_c1+1];
        for (int i=0;i<ile_c1;i++)
            if (i!=klas-1)
              {
              if (c1[i]->State==cbChecked)
                 wsk[i]=1;
              else
                 wsk[i]=0;
              }
            else
               wsk[i]=1;
        wsk[klas-1]=1;
        Child->mEngine->setDiskret(wsk);
        delete[] wsk;
        }
    //*******************************
    dyskr->Close();
    }
//---------------------------------------------------------------------------
void __fastcall pDCtask::wlaczClick(TObject *Sender)
    {
    for (int i=0;i<ile_c1;i++)
        if (i!=klas-1)
          {
          c1[i]->Checked =true;
          }
    }
//---------------------------------------------------------------------------
void __fastcall pDCtask::wylaczClick(TObject *Sender)
    {
    for (int i=0;i<ile_c1;i++)
        if (i!=klas-1)
          {
          c1[i]->Checked =false;
          }
    }
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
__fastcall pProgress::pProgress(bool CreateSuspended,TDokument *x)
    : TThread(CreateSuspended)
{
    Child=x;
    FreeOnTerminate=true;
    op1=0;
}
//---------------------------------------------------------------------------
void __fastcall pProgress::Execute()
    {
      Sleep(250);
      f1=true;
      Child->ProgressBar1->Position=0;
      while (Child->mEngine->progressMax==0)
        Sleep(250);

      Child->ProgressBar1->Max=Child->mEngine->progressMax;

      while(f1)
          {
          if (!Child->ProgressBar1) break;
          if (Terminated)
              {
              Child->ProgressBar1->Position=Child->ProgressBar1->Max;
              break;
              }
          if (op1<Child->mEngine->progress)
              {
              krok=(Child->mEngine->progress-op1);
              op1=Child->mEngine->progress;
              Synchronize(set);
              }
          else if (Child->ProgressBar1->Position==Child->ProgressBar1->Max)
              break;
          Sleep(100);
          }
      if (Child->ProgressBar1)
          {
          Child->mEngine->progress=0;
          Child->mEngine->progressMax=0;
          }
    }
//---------------------------------------------------------------------------
void __fastcall pProgress::set(void)
    {
    if (op1<=Child->mEngine->progressMax && Child->ProgressBar1->Position+krok<Child->ProgressBar1->Max)
        {
        Child->ProgressBar1->Position+=krok;
        }
    else
        {
        Child->ProgressBar1->Position=Child->ProgressBar1->Max;
        f1=false;
        }
    }
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
__fastcall pRead::pRead(bool CreateSuspended,TDokument *x,const char* y)
    : TThread(CreateSuspended)
{
    name=y;
    Child=x;
    FreeOnTerminate=true;
}
//---------------------------------------------------------------------------
void __fastcall pRead::Execute()
    {
    if(Child->StringGrid1)
        {
        Child->Perform(ACTIVEDOC,0,0);
        pProgress *wSP = new pProgress(true,Child);
        wSP->Priority = this->Priority;
        wSP->Resume();
        try
            {
            Child->mEngine->DataLoad((const char*)name);
            //Child->Format2Click(dynamic_cast<TObject *>(Child));  //Ustawienie domyslego formatu KNN
            }
        catch (char* xx)
            {
            wSP->Terminate();
            MessageBeep(-1);
            Application->MessageBox(xx,"Bd", MB_OK);
            }
            
        Child->Perform(ACTIVEDOC,1,0);

        wSP->Terminate();
        }
    }
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
__fastcall pWrite::pWrite(bool CreateSuspended,TDokument *x,const char* y)
    : TThread(CreateSuspended)
{
    name=y;
    Child=x;
    FreeOnTerminate=true;
}
//---------------------------------------------------------------------------
void __fastcall pWrite::Execute()
    {
    if(Child->StringGrid1)
        {
        Child->Perform(ADDPROGRESS,0,0);
        Child->Perform(ACTIVEDOC,0,0);
        pProgress *wSP = new pProgress(true,Child);
        wSP->Priority = this->Priority;
        wSP->Resume();
        try
            {
            Child->mEngine->DataSave((const char*)name);
            }
        catch (char* xx)
            {
            wSP->Terminate();
            MessageBeep(-1);
            Application->MessageBox(xx,"Bd", MB_OK);
            }

        Child->Perform(ACTIVEDOC,1,0);
        Child->Perform(ADDPROGRESS,1,0);

        wSP->Terminate();
        }
    }
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
__fastcall pDokumentOpcje::pDokumentOpcje(bool CreateSuspended,TDokument* x)
    : TThread(CreateSuspended)
{
Child=x;
FreeOnTerminate=true;
good=false;
pro=0;
}
//---------------------------------------------------------------------------
void __fastcall pDokumentOpcje::Execute()
    {
    if(Child->StringGrid1)
        {
        this->utworz();
        OpcjeDokumentu->ShowModal();
        delete OpcjeDokumentu;
        if (Child->mEngine)
            {
            Child->wPriorytet=pro;
            Child->showPanel=false;
            }
        }
    }
//---------------------------------------------------------------------------
void __fastcall pDokumentOpcje::utworz(void)
{

  OpcjeDokumentu=new TForm(Application);
  OpcjeDokumentu->Left = 390;
  OpcjeDokumentu->Top = 177;
  OpcjeDokumentu->BorderStyle = bsSingle;
  TBorderIcons ikony;
  ikony=ikony + (ikony << biSystemMenu);
  OpcjeDokumentu->BorderIcons = ikony;
  AnsiString tytul("Opcje dokumentu ");
  tytul=tytul+Child->Caption;
  OpcjeDokumentu->Caption =tytul;
  OpcjeDokumentu->ClientHeight = 146;
  OpcjeDokumentu->ClientWidth = 336;
  OpcjeDokumentu->Color = clBtnFace;
  OpcjeDokumentu->Font->Charset = DEFAULT_CHARSET;
  OpcjeDokumentu->Font->Color = clWindowText;
  OpcjeDokumentu->Font->Height = -11;
  OpcjeDokumentu->Font->Name = "MS Sans Serif";
  OpcjeDokumentu->Font->Style =OpcjeDokumentu->Font->Style << fsBold;;
  OpcjeDokumentu->OldCreateOrder = false;
  OpcjeDokumentu->PixelsPerInch = 96;
  OpcjeDokumentu->FormStyle=fsStayOnTop;
  OpcjeDokumentu->OnClose=OpcjeClose;

    GroupBox= new TGroupBox(OpcjeDokumentu);
    GroupBox->Left = 8;
    GroupBox->Top = 8;
    GroupBox->Width = 321;
    GroupBox->Height = 129;
    GroupBox->Caption = "Opcje";
    GroupBox->TabOrder = 0;
    GroupBox->Parent=OpcjeDokumentu;

    P1=new TRadioButton(GroupBox);
      P1->Left = 15;
      P1->Top = 21;
      P1->Width = 201;
      P1->Height = 17;
      P1->Caption = "Niski priorytet pracy";
      P1->TabOrder = 0;
      P1->Parent=GroupBox;
      P1->OnClick=P1Click;

    P2=new TRadioButton(GroupBox);
      P2->Left = 15;
      P2->Top = 48;
      P2->Width = 225;
      P2->Height = 17;
      P2->Caption = "Normaly priorytet pracy";
      P2->TabOrder = 1;
      P2->Parent=GroupBox;
      P2->OnClick=P2Click;

    P3=new TRadioButton(GroupBox);
      P3->Left = 15;
      P3->Top = 76;
      P3->Width = 209;
      P3->Height = 17;
      P3->Caption = "Wysoki priorytet pracy";
      P3->TabOrder = 2;
      P3->Parent=GroupBox;
      P3->OnClick=P3Click;

    log=new TCheckBox(GroupBox);
      log->Left = 15;
      log->Top = 100;
      log->Width = 298;
      log->Height = 21;
      log->Caption = "Loguj wszystkie wykonywane operacje do plikw";
      log->TabOrder = 3;
      log->Parent=GroupBox;
      if (Child->mEngine->logowanie==true)
        log->Checked=true;

      if (Child->wPriorytet==1)
        {
          P1->Checked=false;
          P3->Checked=false;
          P2->Checked=true;
        }
      if (Child->wPriorytet==2)
        {
         P1->Checked=false;
         P2->Checked=false;
         P3->Checked=true;
        }
      if (Child->wPriorytet==0)
        {
          P2->Checked=false;
          P3->Checked=false;
          P1->Checked=true;
        }

good =true;
}
//---------------------------------------------------------------------------
void __fastcall pDokumentOpcje::OpcjeClose(TObject *Sender, TCloseAction &Action)
    {
    delete P1;
    delete P2;
    delete P3;
    delete log;
    delete GroupBox;
    }
//---------------------------------------------------------------------------
void __fastcall pDokumentOpcje::P1Click(TObject *Sender)
    {
    if (good && Child->mEngine)
        {
        pro=0;
        if (log->Checked==true) Child->mEngine->logowanie=true;
        else Child->mEngine->logowanie=false;
        OpcjeDokumentu->Close();
        }
    }
//---------------------------------------------------------------------------
void __fastcall pDokumentOpcje::P2Click(TObject *Sender)
    {
    if (good && Child->mEngine)
        {
        pro=1;
        if (log->Checked==true) Child->mEngine->logowanie=true;
        else Child->mEngine->logowanie=false;
        OpcjeDokumentu->Close();
        }
    }
//---------------------------------------------------------------------------
void __fastcall pDokumentOpcje::P3Click(TObject *Sender)
    {
    if (good && Child->mEngine)
        {
        pro=2;
        OpcjeDokumentu->Close();
        if (log->Checked==true) Child->mEngine->logowanie=true;
        else Child->mEngine->logowanie=false;
        }
    }
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
__fastcall pPCATask::pPCATask(bool CreateSuspended,mApp* d,mApp* d1,const PCAopcje& opcje)
    : TThread(CreateSuspended)
{
FreeOnTerminate=true;
lopcje=opcje;
ldane=d;
ldane1=d1;
}
//---------------------------------------------------------------------------
void __fastcall pPCATask::Execute()
{
      if (ldane!=0)
          {
          mDane *localData=ldane->getData();
          float** fdata=localData->konwersjaf_Dane();
          int lcol=localData->preferences->col;
          int lrow=localData->preferences->row;
          if (lopcje.ile>lcol) lopcje.ile=lcol;
          if (lopcje.opcja==3)
                {
                long double **fwyniki;
                PCA<long double> lPca(lrow,lcol,fdata,lopcje.it,lopcje.eps,lopcje.f1);
                //lPca.klasy=false;
                fwyniki=lPca.DoIt(lopcje.QR,lopcje.ile,lopcje.metoda,lopcje.f2);
                if (fwyniki!=0)
                    {
                    if (localData)
                        delete localData;
                    localData=new mDane(lrow,lopcje.ile+1);

                    *localData=fwyniki;
                    ldane->setData(localData);

                    for (int i=0;i<lrow;i++)
                        delete[] fwyniki[i];
                    delete[] fwyniki;
                    }
                if (ldane1!=0)
                    {
                    mDane *flocalData=ldane1->getData();
                    float** ffdata=flocalData->konwersjaf_Dane();

                    PCA<long double> xPca(lrow,lcol,ffdata,lopcje.it,lopcje.eps,lopcje.f1);
                    fwyniki=xPca.ToMulti(lPca,lopcje.ile);
                    if (fwyniki!=0)
                        {
                        if (flocalData)
                            delete flocalData;
                        flocalData=new mDane(lrow,lopcje.ile+1);

                        *flocalData=fwyniki;
                        ldane1->setData(flocalData);
                        for (int i=0;i<lrow;i++)
                            delete[] fwyniki[i];
                        delete[] fwyniki;
                        }
                    else
                        {
                        MessageBeep(-1);
                        Application->MessageBox("Nieprawidowa dugo wektrw wasnych do kombinacji linowej","Bd", MB_OK);
                        }
                    }
                }
          else if (lopcje.opcja==2)
                {
                double **fwyniki;
                PCA<double> lPca(lrow,lcol,fdata,lopcje.it,lopcje.eps,lopcje.f1);
                fwyniki=lPca.DoIt(lopcje.QR,lopcje.ile,lopcje.metoda);
                if (fwyniki!=0)
                    {
                    if (localData)
                        delete localData;
                    localData=new mDane(lrow,lopcje.ile+1);

                    *localData=fwyniki;
                    ldane->setData(localData);

                    for (int i=0;i<lrow;i++)
                        delete[] fwyniki[i];
                    delete[] fwyniki;

                    if (ldane1!=0)
                        {
                        mDane *flocalData=ldane1->getData();
                        float** ffdata=flocalData->konwersjaf_Dane();

                        PCA<double> xPca(lrow,lcol,ffdata,lopcje.it,lopcje.eps,lopcje.f1);
                        fwyniki=xPca.ToMulti(lPca,lopcje.ile);
                        if (fwyniki!=0)
                            {
                            if (flocalData)
                                delete flocalData;
                            flocalData=new mDane(lrow,lopcje.ile+1);

                            *flocalData=fwyniki;
                            ldane1->setData(flocalData);
                            for (int i=0;i<lrow;i++)
                                delete[] fwyniki[i];
                            delete[] fwyniki;
                            }
                        else
                            {
                            MessageBeep(-1);
                            Application->MessageBox("Nieprawidowa dugo wektrw wasnych do kombinacji linowej","Bd", MB_OK);
                            }
                        }
                      }
                }
          else
                {
                float** fwyniki;
                PCA<float> lPca(lrow,lcol,fdata,lopcje.it,lopcje.eps,lopcje.f1);
                fwyniki=lPca.DoIt(lopcje.QR,lopcje.ile,lopcje.metoda);
                if (fwyniki!=0)
                    {
                    if (localData)
                        delete localData;
                    localData=new mDane(lrow,lopcje.ile+1);

                    *localData=fwyniki;
                    ldane->setData(localData);

                    for (int i=0;i<lrow;i++)
                        delete[] fwyniki[i];
                    delete[] fwyniki;
                    if (ldane1!=0)
                        {
                        mDane *flocalData=ldane1->getData();
                        float** ffdata=flocalData->konwersjaf_Dane();

                        PCA<float> xPca(lrow,lcol,ffdata,lopcje.it,lopcje.eps,lopcje.f1);
                        fwyniki=xPca.ToMulti(lPca,lopcje.ile);
                        if (fwyniki!=0)
                            {
                            if (flocalData)
                                delete flocalData;
                            flocalData=new mDane(lrow,lopcje.ile+1);

                            *flocalData=fwyniki;
                            ldane1->setData(flocalData);
                            for (int i=0;i<lrow;i++)
                                delete[] fwyniki[i];
                            delete[] fwyniki;
                            }
                        else
                            {
                            MessageBeep(-1);
                            Application->MessageBox("Nieprawidowa dugo wektrw wasnych do kombinacji linowej","Bd", MB_OK);
                            }
                        }
                    }
                }
          if (lopcje.QR==3)
             {
             MessageBeep(-1);
             Application->MessageBox("Zadana dokadno nie zostaa osignita w procedurze QR.\nSpbuj zwikszy liczb iteracji","Ostrzeenie", MB_OK);
             }
          else if (lopcje.QR==2)
            {
             MessageBeep(-1);
             Application->MessageBox("Podczas wykonywania iteracji w procedurze QR pojawia si kolumna zoona z samych zer","Bd", MB_OK);
            }
          if (lopcje.ile!=0)
              localData->preferences->klas=localData->preferences->col-1;
          else
             {
             MessageBeep(-1);
             Application->MessageBox("Podany prg jest zbyt wysoki,wszystkie wartoci wasne le poniej progu!","Bd", MB_OK);
             }
          for (int i=0;i<lrow;i++)
             delete[] fdata[i];
          delete[] fdata;
          }
          
mZamiana->Perform(ENABLEDOKUMENTS,0,0);
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
__fastcall pPCAKombinacja::pPCAKombinacja(bool CreateSuspended,char* d0,mApp* d,mApp* d1,const PCAopcje& opcje)
    : TThread(CreateSuspended)
{
FreeOnTerminate=true;
lopcje=opcje;
str=new char[strlen(d0)+5];
stpcpy(str,d0);
ldane=d;
ldane1=d1;
}
//---------------------------------------------------------------------------

void __fastcall pPCAKombinacja::Execute()
{
            mApp lApp("Hej");
            lApp.DataLoad(str);
            mDane *lAppData=lApp.getData();
            float** fAppdata=lAppData->konwersjaf_Dane();
            int lAppcol=lAppData->preferences->col;
            int lApprow=lAppData->preferences->row;

            mDane *flocalData=ldane->getData();
            float** ffdata=flocalData->konwersjaf_Dane();
            int flcol=flocalData->preferences->col;
            int flrow=flocalData->preferences->row;

            lopcje.it=10;
            lopcje.eps=0.01;
            lopcje.f1=false;

            PCA<float> lPca(flrow,flcol,ffdata,lopcje.it,lopcje.eps,lopcje.f1);
            float **fwyniki=lPca.ToMulti(fAppdata,lApprow,lAppcol);

            if (fwyniki!=0)
                {
                if (flocalData)
                    delete flocalData;
                flocalData=new mDane(flrow,lApprow+1);

                *flocalData=fwyniki;
                ldane->setData(flocalData);
                if (ldane1!=0)
                    {
                    mDane *flData=ldane1->getData();
                    float** xfdata=flData->konwersjaf_Dane();
                    int xflcol=flData->preferences->col;
                    int xflrow=flData->preferences->row;
                    PCA<float> xPca(xflrow,xflcol,xfdata,lopcje.it,lopcje.eps,lopcje.f1);
                    float **xwynik=xPca.ToMulti(fAppdata,lApprow,lAppcol);
                    if (flData)
                        delete flData;
                    flData=new mDane(xflrow,lApprow+1);

                    *flData=xwynik;
                    ldane1->setData(flData);
                    if (xwynik!=0)
                      {
                      for (int i=0;i<xflrow;i++)
                          delete[] xwynik[i];
                      delete[] xwynik;
                      }
                    if (xfdata!=0)
                      {
                      for (int i=0;i<xflrow;i++)
                          delete[] xfdata[i];
                      delete[] xfdata;
                      }
                    }
                }
            else
                {
                MessageBeep(-1);
                Application->MessageBox("Nieprawidowa dugo wektrw wasnych do kombinacji linowej","Bd", MB_OK);
                }

            if (ffdata!=0)
                {
                for (int i=0;i<flrow;i++)
                    delete[] ffdata[i];
                delete[] ffdata;
                }

            if (fAppdata!=0)
                {
                for (int i=0;i<lApprow;i++)
                    delete[] fAppdata[i];
                delete[] fAppdata;
                }

            if (fwyniki!=0)
                {
                for (int i=0;i<flrow;i++)
                    delete[] fwyniki[i];
                delete[] fwyniki;
                }
delete[] str;
str=0;
mZamiana->Perform(ENABLEDOKUMENTS,0,0);
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
