//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#if !defined (__mStringH)
	#include "mString.h"
#endif

#include "mainZamiana.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TmZamiana *mZamiana;
//---------------------------------------------------------------------------
__fastcall TmZamiana::TmZamiana(TComponent* Owner)
    : TForm(Owner)
{

Application->OnHint=OnHint;
//Application->OnException = AppException;
Application->HelpFile = "PomocETBD.hlp";


TRegistry *regKey=new TRegistry();
bool keyGood=regKey->OpenKey("\\Software\\Zamiana danych",false);
if (keyGood==true)
    {
    LoadPath=regKey->ReadString("LoadPath");
    SavePath=regKey->ReadString("SavePath");
    TypZamiany1=regKey->ReadInteger("Typ1");
    TypZamiany1Start=regKey->ReadInteger("Typ1Start");
    TypZamiany2=regKey->ReadInteger("Typ2");
    FastSlow=regKey->ReadInteger("FastSlow");
    PageIndex=regKey->ReadInteger("PageIndex");
    }
else
    {
    LoadPath="c:\\Temp";
    SavePath="c:\\Temp";
    TypZamiany1=4;
    TypZamiany2=0;
    TypZamiany1Start=0;
    PageIndex=4;
    FastSlow=true;
    }

lSchowek=0;
this->setDeActive();
this->setHint();
}
//---------------------------------------------------------------------------
void __fastcall TmZamiana::FormClose(TObject *Sender, TCloseAction &Action)
{
for(int i = 0; i < MDIChildCount; i++)
    {
    MDIChildren[i]->Close();
    }
TRegistry *regKey=new TRegistry();
bool keyGood=regKey->OpenKey("\\Software\\Zamiana danych",false);
String pat0(LoadPath.c_str());
String pat1(SavePath.c_str());
if (keyGood==true)
    {
    regKey->WriteString("LoadPath",pat0);
    regKey->WriteString("SavePath",pat1);
    regKey->WriteInteger("Typ1",TypZamiany1);
    regKey->WriteInteger("Typ1Start",TypZamiany1Start);
    regKey->WriteInteger("Typ2",TypZamiany2);
    regKey->WriteInteger("FastSlow",FastSlow);
    regKey->WriteInteger("PageIndex",PageIndex);
    }
else
    {
    regKey->OpenKey("\\Software\\Zamiana danych",true);
    regKey->WriteString("LoadPath",pat0);
    regKey->WriteString("SavePath",pat1);
    regKey->WriteInteger("Typ1",TypZamiany1);
    regKey->WriteInteger("Typ1Start",TypZamiany1Start);
    regKey->WriteInteger("Typ2",TypZamiany2);
    regKey->WriteInteger("FastSlow",FastSlow);
    regKey->WriteInteger("PageIndex",PageIndex);
    }

}
//---------------------------------------------------------------------------
void __fastcall TmZamiana::setHint(void)
    {
    New1->Hint="Generowanie losowych danych";
    Nowy0->Hint=New1->Hint;
    Trans1->Hint="Wykonanie transformacji pierwszego typu|Wykonuje transformacj danych pierwszego typu zgodnie z ustawionymi opcjami";
    Zamiana0->Hint=Trans1->Hint;
    Trans2->Hint="Wykonanie transformacji drugiego typu|Wykonuje transformacj danych drugiego typu zgodnie z ustawionymi opcjami";
    Zamiana1->Hint=Trans2->Hint;
    Trans3->Hint="Wykonanie transformacji PCA";
    Zamiana2->Hint=Trans3->Hint;
    SaveAs1->Hint="Zapisanie pliku";
    Zapis0->Hint=SaveAs1->Hint;
    Open1->Hint="Otwarcie pliku";
    Odczyt0->Hint=Open1->Hint;
    Cut1->Hint="Usuwanie danych|Usuwanie w otwartym dokumencie wierszy i kolumn";
    Usun0->Hint=Cut1->Hint;
    Tile1->Hint="Ustawianie pozycji okienek -> kaskada";
    Cas0->Hint=Tile1->Hint;
    Cascade1->Hint="Ustawianie pozycji okienek -> poziomo";
    Up0->Hint=Cascade1->Hint;
    ArrangeAll1->Hint="Ustawianie pozycji okienek -> pionowo";
    Down0->Hint=ArrangeAll1->Hint;
    Copy1->Hint="Kopiuj do schowka|Kopiowanie zaznaczonego fragmentu do schowka";
    Kopiuj0->Hint=Copy1->Hint;
    Paste1->Hint="Wklej ze schowka|Wklejenie ze schowka";
    Wklej0->Hint=Paste1->Hint;
    }
//---------------------------------------------------------------------------
void __fastcall TmZamiana::setActive(void)
    {
    New1->Enabled=true;
    Save1->Enabled=true;
    SaveAs1->Enabled=true;
    Cut1->Enabled=true;
    Copy1->Enabled=true;
    Window1->Enabled=true;
    Trans1->Enabled=true;
    Trans2->Enabled=true;
    Trans3->Enabled=true;


    Zamiana0->Enabled=true;
    Zamiana1->Enabled=true;
    Zamiana2->Enabled=true;
    Kopiuj0->Enabled=true;
    Wklej0->Enabled=true;
    Usun0->Enabled=true;
    Up0->Enabled=true;
    Down0->Enabled=true;
    Cas0->Enabled=true;
    Zapis0->Enabled=true;
    Paste1->Enabled=true;
    Schowek1->Enabled=true;


    Zamiana0->ShowHint=true;
    Zamiana1->ShowHint=true;
    Zamiana2->ShowHint=true;
    Kopiuj0->ShowHint=true;
    Wklej0->ShowHint=true;
    Usun0->ShowHint=true;
    Up0->ShowHint=true;
    Down0->ShowHint=true;
    Cas0->ShowHint=true;
    Zapis0->ShowHint=true;

    }
//---------------------------------------------------------------------------
void __fastcall TmZamiana::setDeActive(void)
    {
    New1->Enabled=true;
    Save1->Enabled=false;
    SaveAs1->Enabled=false;
    Cut1->Enabled=false;
    Copy1->Enabled=false;
    Window1->Enabled=false;
    Trans1->Enabled=false;
    Trans2->Enabled=false;
    Trans3->Enabled=false;

    Zamiana0->Enabled=false;
    Zamiana1->Enabled=false;
    Zamiana2->Enabled=false;
    Kopiuj0->Enabled=false;
    Wklej0->Enabled=false;
    Usun0->Enabled=false;
    Up0->Enabled=false;
    Down0->Enabled=false;
    Cas0->Enabled=false;
    Zapis0->Enabled=false;
    Paste1->Enabled=false;
    Schowek1->Enabled=false;

    Zamiana0->ShowHint=false;
    Zamiana1->ShowHint=false;
    Zamiana2->ShowHint=false;
    Kopiuj0->ShowHint=false;
    Wklej0->ShowHint=false;
    Usun0->ShowHint=false;
    Up0->ShowHint=false;
    Down0->ShowHint=false;
    Cas0->ShowHint=false;
    Zapis0->ShowHint=false;
    }
//---------------------------------------------------------------------------
void __fastcall TmZamiana::MActivate(TMessage& Message)
    {
    /*
    char msg[100];
    sprintf(msg,"Error %d w procedurze %d",Message.WParam,Message.LParam);
    Application->MessageBox(msg,"Error",MB_OK);
    */
    if (Message.WParam==0 && MDIChildCount-1<=0)
        {
        setDeActive();
        }
    else if (Message.WParam==1)
        {
        setDeActive();
        Nowy0->Enabled=true;
        Odczyt0->Enabled=true;
        Window1->Enabled=true;
        }
    else if (Message.WParam==2)
        {
        setActive();
        }
    Message.Result=true;
    }
//---------------------------------------------------------------------------
void __fastcall TmZamiana::setType(TMessage& Message)
    {
    /*
    Message.LParam 2 lub 3 KNN
                   4 lub 5 FSM
                   6 lub 7 C4.5
    */
    int num=Message.WParam;
    bool f1;
    if ((Message.LParam/2)*2==Message.LParam) f1=false;
    else f1=true;
    int res=findTest(num,f1);
    if (res>=0)
        {
        TDokument* TheForm2 =dynamic_cast<TDokument*>(MDIChildren[res]);
        TheForm2->showPanel=true;
        if (Message.LParam==2 || Message.LParam==3)
            TheForm2->Format2Click(dynamic_cast<TObject *>(TheForm2));
        else if (Message.LParam==4 || Message.LParam==5)
            TheForm2->Format3Click(dynamic_cast<TObject *>(TheForm2));
        else if (Message.LParam==6 || Message.LParam==7)
            TheForm2->Format4Click(dynamic_cast<TObject *>(TheForm2));
        Message.Result=true;
        }
    else
        Message.Result=false;
    }
//---------------------------------------------------------------------------
void __fastcall TmZamiana::setStatus(TMessage& Message)
    {
    int num=Message.WParam;
    if (num==0)
        WindowState=wsNormal;
    else if (num==1)
        WindowState=wsMinimized;
    else
        WindowState=wsMaximized;
    Message.Result=true;
    }
//---------------------------------------------------------------------------
void __fastcall TmZamiana::OnHint(TObject* Sender)
    {
    StatusBar1->SimpleText=Application->Hint;
    }
//---------------------------------------------------------------------------
/*
void __fastcall TmZamiana::AppException(TObject *Sender, Exception *E)
    {
      Application->ShowException(E);
      //Application->Terminate();
    }
*/
//---------------------------------------------------------------------------
void __fastcall TmZamiana::addStatusShow(TMessage& Message)
    {
    /*
    Komunikat o zakoczeniu zadadnia
    */
    if (Message.WParam==0)
        StatusBar1->SimpleText="Wywietlam dane ";
    else if (Message.WParam==1)
        StatusBar1->SimpleText="Dane wywietlone ";
    else if (Message.WParam==2)
        StatusBar1->SimpleText="Usuwanie wierszy i kolumn";
    else if (Message.WParam==3)
        {
        if (Message.LParam==0)
            StatusBar1->SimpleText="Kolumna usunita";
        else
            StatusBar1->SimpleText="Wiersz usunity";
        }
    else if (Message.WParam==4)
        StatusBar1->SimpleText="Dokonuje prostej zamiany danych";
    else if (Message.WParam==5)
        StatusBar1->SimpleText="Wykonuj transformacj PCA";
    else if (Message.WParam==6)
        StatusBar1->SimpleText="Tworz kombinacj liniow danych";
    }
//---------------------------------------------------------------------------
void __fastcall TmZamiana::enableDokuments(TMessage& Message)
    {
    if (Message.WParam==0)
        {
        for(int i = 0; i < MDIChildCount; i++)
            {
            if ((dynamic_cast<TDokument*> (MDIChildren[i]))->working==true)
                {
                (dynamic_cast<TDokument*> (MDIChildren[i]))->Perform(ACTIVEDOC,1,0);
                }
            }
        }
    else
        {
        for(int i = 0; i < MDIChildCount; i++)
            {
            if ((dynamic_cast<TDokument*> (MDIChildren[i]))->working==false)
                {
                (dynamic_cast<TDokument*> (MDIChildren[i]))->Perform(ACTIVEDOC,0,0);
                }
            }
        }
    }
//---------------------------------------------------------------------------
bool __fastcall TmZamiana::compareName(const char* x ,const char* y)const
    {
    AnsiString x1(x),y1(y);
    x1=ExtractFileName(x1);
    y1=ExtractFileName(y1);
    mString name1(x1.c_str()),name2(y1.c_str());
    name1.del(name1.find("."),-1);
    name2.del(name2.find("."),-1);
    if (name1==name2) return true;
    else return false;
    }
//---------------------------------------------------------------------------
bool __fastcall TmZamiana::CheckIfTest(const AnsiString x)const
    {
    AnsiString x1=ExtractFileName(x);

    mString name1(x1.c_str()),name2("t"),name3("test"),name4("tes");
    name1.del(0,name1.find(".")+1);

    if (name1==name2) return true;
    else if (name1==name3) return true;
    else if (name1==name4) return true;
    else return false;
    }
//---------------------------------------------------------------------------
int __fastcall TmZamiana::findTest(const int x,const bool y)
    {
       int res=-1;
       if (MDIChildCount>=2)
           {
           for(int i = 0; i < MDIChildCount; i++)
                {
                TDokument* TheForm2 =dynamic_cast<TDokument*>(MDIChildren[i]);
                if (y==false)
                    {
                    if (TheForm2 && TheForm2->linked==true && TheForm2->docNumber==x && TheForm2->test==true)
                        res=i;
                    }
                else
                    {
                    if (TheForm2 && TheForm2->linked==true && TheForm2->docNumber==x && TheForm2->test==false)
                        res=i;
                    }
                }
           }
       return res;
    }
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
void __fastcall TmZamiana::CheckForTest(void)
{
    TDokument* Child;
    Child =dynamic_cast<TDokument*>(mZamiana->ActiveMDIChild);
    if (Child)
      {
      TDokument *TheForm2;
      for(int i = 1; i < MDIChildCount; i++)
          {
          TheForm2 =dynamic_cast<TDokument*>(MDIChildren[i]);
          if (TheForm2->linked==false && compareName((const char*)(*Child->mEngine->FName),(const char*)(*TheForm2->mEngine->FName)))
              {
              TheForm2->linked=true;
              Child->linked=true;
              Child->docNumber=TheForm2->docNumber;
              }
        }
    }
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
void __fastcall TmZamiana::Open1Click(TObject *Sender)
  {
  TOpenDialog *OpenDialog=new TOpenDialog(mZamiana);
  OpenDialog->Title="Otwrz plik";
  OpenDialog->Options << ofHideReadOnly << ofPathMustExist << ofFileMustExist;
  OpenDialog->Filter = "Pliki KNN (*.d/*.t)|*.d;*.t|Pliki FSM (*.data\*.test)|*.data;*.test|Pliki C4.5 (*.dat\*.tes)|*.dat;*.tes|Wszystkie pliki (*.*)|*.*";
  OpenDialog->FilterIndex = PageIndex;
  if (LoadPath!="\0")
      OpenDialog->InitialDir=LoadPath;
  if (OpenDialog->Execute())
          {
          if (FileExists (OpenDialog->FileName))
              {
              TDokument *Child;
              LoadPath=ExtractFilePath(OpenDialog->FileName);
              try
                  {
                  char* str=(OpenDialog->FileName).c_str();

                  Child = new TDokument(Application,str);
                  Child->docNumber=MDIChildCount-1;
                  Child->test=CheckIfTest(OpenDialog->FileName);

                  pRead *wSP = new pRead(true,Child,str);
                  if (Child->wPriorytet==0)
                      wSP->Priority = tpIdle;
                  else if (Child->wPriorytet==1)
                      wSP->Priority = tpNormal;
                  else
                      wSP->Priority = tpHighest;
                  wSP->Resume();

                  }
              catch (char* x)
                  {
                  MessageBeep(-1);
                  Application->MessageBox(x,"Bd", MB_OK);
                  }

              if (MDIChildCount>1)
                  CheckForTest();

              try
                  {
                  Child->ShowGrid1();
                  }
              catch (char* x)
                  {
                  MessageBeep(-1);
                  Application->MessageBox(x,"Bd", MB_OK);
                  }

              this->setActive();
              }
          }
  PageIndex=OpenDialog->FilterIndex;
  delete OpenDialog;

  }
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
void __fastcall TmZamiana::SaveAs1Click(TObject *Sender)
{
TDokument* TheForm;
TheForm =dynamic_cast<TDokument*>(mZamiana->ActiveMDIChild);
if (TheForm)
  {
  TSaveDialog *SaveDialog=new TSaveDialog(mZamiana);
  SaveDialog->Title="Zapisz plik ";
  SaveDialog->Title=SaveDialog->Title+TheForm->Caption;
  SaveDialog->FileName=TheForm->Caption;
  SaveDialog->Options << ofHideReadOnly << ofPathMustExist << ofOverwritePrompt;
  SaveDialog->Filter = "Pliki KNN (*.d/*.t)|*.d;*.t|Pliki FSM (*.data\*.test)|*.data;*.test|Pliki C4.5 (*.dat\*.tes)|*.dat;*.tes|Wszystkie pliki (*.*)|*.*";
  SaveDialog->FilterIndex = PageIndex;
  if (SavePath!="\0")
    SaveDialog->InitialDir=SavePath;
  if (SaveDialog->Execute())
          {
          //  TheForm->WindowState = wsMinimized;
          SavePath=ExtractFilePath(SaveDialog->FileName);
          try
              {
              TheForm->Caption=ExtractFileName(SaveDialog->FileName);
              *TheForm->mEngine->FName=(ExtractFileName(SaveDialog->FileName)).c_str();
              pWrite *wSP = new pWrite(true,TheForm,(SaveDialog->FileName).c_str());
              if (TheForm->wPriorytet==0)
                  wSP->Priority = tpIdle;
              else if (TheForm->wPriorytet==1)
                  wSP->Priority = tpNormal;
              else
                  wSP->Priority = tpHighest;
              wSP->Resume();
              if (TheForm->linked)
                {
                int res=findTest(TheForm->docNumber,TheForm->test);
                if (res>=0)
                    {
                    TDokument* TheForm2 =dynamic_cast<TDokument*>(MDIChildren[res]);
                    TheForm2->newFName((const char*)*TheForm->mEngine->FName);
                    AnsiString lpath(SavePath),name((const char*)*TheForm2->mEngine->FName);
                    lpath=lpath+ExtractFileName(name);
                    pWrite *wSP2 = new pWrite(true,TheForm2,lpath.c_str());
                    if (TheForm2->wPriorytet==0)
                      wSP2->Priority = tpIdle;
                    else if (TheForm2->wPriorytet==1)
                      wSP2->Priority = tpNormal;
                    else
                      wSP2->Priority = tpHighest;
                    wSP2->Resume();

                    }
                }
              }
          catch (char* x)
              {
              MessageBeep(-1);
              Application->MessageBox(x,"Bd", MB_OK);
              }
          }
  PageIndex=SaveDialog->FilterIndex;
  delete SaveDialog;
  }
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------

void __fastcall TmZamiana::Exit1Click(TObject *Sender)
{
mZamiana->Close();
}
//---------------------------------------------------------------------------

void __fastcall TmZamiana::Cut1Click(TObject *Sender)
{
   TDokument* TheForm;
   TheForm =dynamic_cast<TDokument*>(mZamiana->ActiveMDIChild);
   if (TheForm && TheForm->showPanel==false)
    {
        TRect prst;
        prst.Bottom=TheForm->Column0;
        prst.Top=TheForm->Row0;
        if (TheForm->Column1==TheForm->Column0 &&
            TheForm->Row1==TheForm->Row1)
            {
            prst.Right=TheForm->StringGrid1->Col;
            prst.Left=TheForm->StringGrid1->Row;
            }
        else
            {
            prst.Right=TheForm->Column1;
            prst.Left=TheForm->Row1;
            TheForm->Column1=0;
            TheForm->Row1=0;
            }
        pUsuwanie *wSP = new pUsuwanie(true,TheForm,prst,true);
        if (TheForm->wPriorytet==0)
            wSP->Priority = tpIdle;
        else if (TheForm->wPriorytet==1)
            wSP->Priority = tpNormal;
        else
            wSP->Priority = tpHighest;
        wSP->Resume();
    }

   /*
   TDokument* TheForm;
   TheForm =dynamic_cast<TDokument*>(mZamiana->ActiveMDIChild);
   if (TheForm && TheForm->showPanel==false)
      {
      TheForm->showPanel=true;
      TUsuwanie *kasowanie=new TUsuwanie(TheForm,TheForm);
      kasowanie->Show();
      }
//    delete opcje;
     */
}
//---------------------------------------------------------------------------
void __fastcall TmZamiana::Trans1Click(TObject *Sender)
{
   TDokument* TheForm;
   TheForm =dynamic_cast<TDokument*>(mZamiana->ActiveMDIChild);
   if (TheForm && TheForm->linked)
      {
      int res=findTest(TheForm->docNumber,TheForm->test);
      if (res>=0)
            {
            TDokument* TheForm2 =dynamic_cast<TDokument*>(MDIChildren[res]);
            pTransform1A *wSP;

            if (TheForm->test==false)
                wSP = new pTransform1A (true,TheForm,TheForm2,TypZamiany1,TypZamiany1Start);
            else
                wSP = new pTransform1A (true,TheForm2,TheForm,TypZamiany1,TypZamiany1Start);

            if (TheForm->wPriorytet==0)
                wSP->Priority = tpIdle;
            else if (TheForm->wPriorytet==1)
                wSP->Priority = tpNormal;
            else
                wSP->Priority = tpHighest;
            wSP->Resume();
            }
        }
   else if (TheForm)
        {
        pTransform1 *wSP = new pTransform1 (true,TheForm,TypZamiany1,TypZamiany1Start);
        if (TheForm->wPriorytet==0)
            wSP->Priority = tpIdle;
        else if (TheForm->wPriorytet==1)
            wSP->Priority = tpNormal;
        else
            wSP->Priority = tpHighest;
        wSP->Resume();
        }
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------

void __fastcall TmZamiana::Trans2Click(TObject *Sender)
{
TDokument* TheForm;
   TheForm =dynamic_cast<TDokument*>(mZamiana->ActiveMDIChild);
   if (TheForm && TheForm->linked)
      {
      int res=findTest(TheForm->docNumber,TheForm->test);
      if (res>=0)
            {
            TDokument* TheForm2 =dynamic_cast<TDokument*>(MDIChildren[res]);
            pTransform2A *wSP;

            if (TheForm->test==false)
                wSP = new pTransform2A (true,TheForm,TheForm2,TypZamiany2,FastSlow);
            else
                wSP = new pTransform2A (true,TheForm2,TheForm,TypZamiany2,FastSlow);

            if (TheForm->wPriorytet==0)
                wSP->Priority = tpIdle;
            else if (TheForm->wPriorytet==1)
                wSP->Priority = tpNormal;
            else
                wSP->Priority = tpHighest;
            wSP->Resume();
            }
      }
   else if (TheForm)
        {
        pTransform2 *wSP = new pTransform2 (true,TheForm,TypZamiany2,FastSlow);
        if (TheForm->wPriorytet==0)
            wSP->Priority = tpIdle;
        else if (TheForm->wPriorytet==1)
            wSP->Priority = tpNormal;
        else
            wSP->Priority = tpHighest;
        wSP->Resume();
        }
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------

void __fastcall TmZamiana::OptionTrans1Click(TObject *Sender)
{
    TZamiana1 *win;
    win=new TZamiana1(Application,&TypZamiany1,&TypZamiany1Start);
    win->Show();

}
//---------------------------------------------------------------------------

void __fastcall TmZamiana::OptionTrans2Click(TObject *Sender)
{
    TZamiana2 *win;
    win=new TZamiana2(Application,&TypZamiany2,&FastSlow);
    win->Show();
}
//---------------------------------------------------------------------------

void __fastcall TmZamiana::Copy1Click(TObject *Sender)
{
   if (lSchowek==0)
      {
      lSchowek=new TSchowek(Application);
      }
   TDokument* TheForm;
   TheForm =dynamic_cast<TDokument*>(mZamiana->ActiveMDIChild);
   if (TheForm && TheForm->showPanel==false)
    {
        TRect prst;
        prst.Bottom=TheForm->Column0;
        prst.Top=TheForm->Row0;
        if (TheForm->Column1==TheForm->Column0 &&
            TheForm->Row1==TheForm->Row1)
            {
            prst.Right=TheForm->StringGrid1->Col;
            prst.Left=TheForm->StringGrid1->Row;
            }
        else
            {
            prst.Right=TheForm->Column1;
            prst.Left=TheForm->Row1;
            TheForm->Column1=0;
            TheForm->Row1=0;
            }
        pUsuwanie *wSP = new pUsuwanie(true,TheForm,prst,false);
        if (TheForm->wPriorytet==0)
            wSP->Priority = tpIdle;
        else if (TheForm->wPriorytet==1)
            wSP->Priority = tpNormal;
        else
            wSP->Priority = tpHighest;
        wSP->Resume();
    }
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
void __fastcall TmZamiana::Save1Click(TObject *Sender)
{
TDokument* TheForm;
TheForm =dynamic_cast<TDokument*>(mZamiana->ActiveMDIChild);
if (TheForm)
  {
    try
        {
        AnsiString llpath(SavePath),name((const char*)*TheForm->mEngine->FName);
        llpath=llpath+ExtractFileName(name);

        pWrite *wSP = new pWrite(true,TheForm, llpath.c_str());
        if (TheForm->wPriorytet==0)
        wSP->Priority = tpIdle;
        else if (TheForm->wPriorytet==1)
        wSP->Priority = tpNormal;
        else
        wSP->Priority = tpHighest;
        wSP->Resume();
        if (TheForm->linked)
            {
            int res=findTest(TheForm->docNumber,TheForm->test);
            if (res>=0)
                {
                TDokument* TheForm2 =dynamic_cast<TDokument*>(MDIChildren[res]);
                AnsiString lpath(SavePath),name((const char*)*TheForm2->mEngine->FName);
                lpath=lpath+ExtractFileName(name);
                pWrite *wSP2 = new pWrite(true,TheForm2,lpath.c_str());
                if (TheForm2->wPriorytet==0)
                  wSP2->Priority = tpIdle;
                else if (TheForm2->wPriorytet==1)
                  wSP2->Priority = tpNormal;
                else
                  wSP2->Priority = tpHighest;
                wSP2->Resume();
                }
            }
        }
    catch (char* x)
        {
        MessageBeep(-1);
        Application->MessageBox(x,"Bd", MB_OK);
        }
  }
}
//---------------------------------------------------------------------------
void __fastcall TmZamiana::CloseAll1Click(TObject *Sender)
{
TCloseAction act=caNone;
FormClose(Sender,act);
}
//---------------------------------------------------------------------------
void __fastcall TmZamiana::Schowek1Click(TObject *Sender)
{
    if (lSchowek==0)
        {
        lSchowek=new TSchowek(Application);
        }
    else
        lSchowek->SchowekRefresh();

    lSchowek->Show();
}
//---------------------------------------------------------------------------
void __fastcall TmZamiana::Nowy0Click(TObject *Sender)
{
  int x[4];
  bool yy;
  x[0]=100;
  x[1]=10;
  x[2]=5;
  x[3]=1;
  TNoweDane *xNoweDane=new TNoweDane(Application,x);
  xNoweDane->ShowModal();
  if (x[0]>0)
    {
    if (x[3]>0) yy=true;
    else yy=false;
    TDokument* Child;
    Child = new TDokument(Application,"NoName.data");
    Child->docNumber=MDIChildCount-1;
    Child->Caption = "NONAME" + IntToStr(MDIChildCount);
    if (Child)
      {
      Child->mEngine->losuj(x[0],x[1],x[2],yy);
      Child->ShowGrid1();
      }
    }
}
//---------------------------------------------------------------------------
void __fastcall TmZamiana::Trans3Click(TObject *Sender)
{
Zamiana2Click(Sender);
}
//---------------------------------------------------------------------------
void __fastcall TmZamiana::Zamiana2Click(TObject *Sender)
{
   TPCAForm *win;
   TDokument* Child,*Child1=0;
   Child =dynamic_cast<TDokument*>(mZamiana->ActiveMDIChild);
   if (Child && Child->linked)
      {
      bool f1=false,f2=false;
      int res=findTest(Child->docNumber,Child->test);
      if (res>=0)
            {
            Child1 =dynamic_cast<TDokument*>(MDIChildren[res]);

            if (Child->test==false)
                win=new TPCAForm(Application,Child,Child1,&f1);
            else
                win=new TPCAForm(Application,Child1,Child,&f2);

            win->ShowModal();

            if(f1==true)
                Child->ShowGrid1();
            if (f1==true)
                Child1->ShowGrid1();
            }
      }
    else
        {
        bool f1=false;
        win=new TPCAForm(Application,Child,0,&f1);
        win->ShowModal();
        if (f1==true)
            Child->ShowGrid1();
        }
}
//---------------------------------------------------------------------------

void __fastcall TmZamiana::Wklej0Click(TObject *Sender)
{
    if (lSchowek==0)
        {
        lSchowek=new TSchowek(Application);
        }
    else
        lSchowek->SchowekRefresh();
    TDokument* Child;
    char* data;
    Child =dynamic_cast<TDokument*>(mZamiana->ActiveMDIChild);
    if (Child)
        {
        int dll=0;
        data=lSchowek->SchowekGet(dll);
        TWklejForm *wForm= new TWklejForm(Application,Child,data,dll);
        wForm->ShowModal();
        Child->ShowGrid1();
        delete[] data;
        }
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
void __fastcall TmZamiana::Paste1Click(TObject *Sender)
{
Wklej0Click(Sender);
}
//---------------------------------------------------------------------------
void __fastcall TmZamiana::Tile1Click(TObject *Sender)
{
TileMode = tbHorizontal;
Tile();
}
//---------------------------------------------------------------------------
void __fastcall TmZamiana::Cascade1Click(TObject *Sender)
{
Cascade();
}
//---------------------------------------------------------------------------
void __fastcall TmZamiana::ArrangeAll1Click(TObject *Sender)
{
TileMode = tbVertical;
Tile();
}
//---------------------------------------------------------------------------

void __fastcall TmZamiana::Contents1Click(TObject *Sender)
{
Application->HelpCommand(HELP_FINDER, 0);
}
//---------------------------------------------------------------------------
void __fastcall TmZamiana::About1Click(TObject *Sender)
{
TAboutBox *oProgramie=new TAboutBox(Application);
oProgramie->ShowModal();
}
//---------------------------------------------------------------------------

