//---------------------------------------------------------------------------

//#include <vcl.h>
/*
#include <stdio.h>
#include <stdlib.h>
*/
#include <conio.h>
#include <io.h>
#include <DateUtils.hpp>
//#include <iostream.h>
#include "nic_all.h"
#pragma hdrstop





//---------------------------------------------------------------------------

#pragma argsused
int main(int argc, char* argv[])
  {
  DecimalSeparator='.';
  cout << "Procrustes Analysis" << endl;

  if ((argc > 3) && (access(argv[1],0) == 0) && (access(argv[2],0) == 0) &&
      ((access(argv[3],2) == 0) || (access(argv[3],0) != 0)))
    {
    TDateTime t1=Now();

    DataFile testee, target, destination;
    Procrust pa(testee,target,destination);
    cout << "Processing " << argv[1];
    pa.pTestee()->LoadFile(argv[1]);
    cout << endl << "Processing " << argv[2];
    pa.pTarget()->LoadFile(argv[2]);

    cout << endl << "Calculating...";
    pa.ProcrustesAnalysis();

    if (pa.ProcError=="OK")
      {
      cout << endl << "Saving file " << argv[3];
      pa.pDestination()->SaveFile(argv[3]);

      cout << endl << "Accuracy = ";
      cout << FloatToStrF(pa.Accuracy,ffExponent,4,2).c_str();

      cout << endl << "Finished in " << FloatToStrF(MilliSecondsBetween(Now(),t1)/1000.0,ffFixed,15,3).c_str() << " seconds";
      cout << endl << "Complete!" << endl;
      }
      else
        cout << endl <<" Procrustet Analysis Error: " << pa.ProcError.c_str() << endl;
    }
    else
      {
      cout << "USAGE:" << endl;
      cout << "  pocrust.exe testee target destination" << endl;
      }

  //cout << endl << "Done" << endl;
  //getch();
  return 0;
  }
//---------------------------------------------------------------------------
 