using System;
using System.Collections.Generic;
using System.Text;
using Intemi;


namespace ToyMachines
{

    public class DataTableGeneratorConfig : IConfiguration
    {
        int vectorsCount;
        public int VectorsCount
        {
            get { return vectorsCount; }
            set { vectorsCount = value; }
        }
        int featuresCount;
        public int FeaturesCount
        {
            get { return featuresCount; }
            set { featuresCount = value; }
        }

        public void Configure(ConfigBuilder confBuilder)
        {
            //confBuilder.DeclareInput("Dataset",
            //    new Type[] { typeof(IDataTable), typeof(ITargets) });
            confBuilder.DeclareOutput("DataTable", "OutDataTable",
                new Type[] { typeof(IDataTable) });
        }
        public object Clone()
        {
            DataTableGeneratorConfig c = new DataTableGeneratorConfig();
            c.featuresCount = featuresCount;
            c.vectorsCount = vectorsCount;
            return c;
        }
    }

    [Machine("DataTable Generator", typeof(DataTableGeneratorConfig))]
    public class DataTableGenerator : IMachine
    {
        IMachineBase machineBase;
        public void SetMachineBase(IMachineBase mb) { machineBase = mb; }

        DataTable outDataTable = null;
        public DataTable OutDataTable
        {
            get { return outDataTable; }
            set { outDataTable = value; }
        }
        public void Run(ref bool shouldTerminate)
        {
            DataTableGeneratorConfig conf = 
                machineBase.ConfBase.Configuration as DataTableGeneratorConfig;
            DataTableBuilder dtb = new DataTableBuilder();

            dtb.VectorsCount = conf.VectorsCount;
            dtb.FeaturesCount = conf.FeaturesCount;

            for (int i = 0; i < conf.FeaturesCount; i++)
            {
                dtb.SetFeatureName(i, i.ToString());
                dtb.SetOrdered(i, true);
            }

            float[,] v = dtb.Values;
            bool[,] b = dtb.Missing;
            Random r = new Random();
            for (int i = 0; i < conf.VectorsCount; i++)
            {
                for (int j = 0; j < conf.FeaturesCount; j++)
                {
                    v[i, j] = r.Next(100);
                    b[i, j] = false;
                }
            }

        }
    }
}