#ifndef _MATRIX_H_
#define _MATRIX_H_
 
class Matrix
  {
  private:
  unsigned int row, col;
  double **matrix;

  public:
  Matrix(unsigned int row, unsigned int col, double value=0, int fill=0);
  Matrix(const Matrix & m);
  ~Matrix();

  unsigned int nrows() const;
  unsigned int ncols() const;
  
  void UstawElement(unsigned int row, unsigned int col, double value);
  double PobierzElement(unsigned int row, unsigned int col) const;

  Matrix & operator=(const Matrix & m);
  Matrix & operator+=(const Matrix & m);
  Matrix & operator-=(const Matrix & m);
  Matrix & operator*=(const Matrix & m);
  Matrix & operator*=(double x);

  Matrix & Resize(unsigned int row, unsigned int col);
  Matrix & AddRow(double * vec, unsigned int n);
  Matrix & AddRows(const Matrix & m);

  double * operator[](unsigned int row) const;

  //zwraca wskaznik do samej macierzy
  double ** pmatrix() const;

  Matrix Transpose() const;
  double Trace() const;
  //max lub min w kolumnach
  double ColMax(unsigned int col) const;
  double ColMin(unsigned int col) const;

  };

Matrix operator+(const Matrix & m1, const Matrix & m2);
Matrix operator-(const Matrix & m1, const Matrix & m2);
Matrix operator*(const Matrix & m1, const Matrix & m2);
Matrix operator*(const Matrix & m, double x);
Matrix operator*(double x, const Matrix & m);


void WypiszM(const Matrix & m);

#endif